<?php

/* 3 Steps Block */

class PXS_Steps_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => '3 Steps',
			'size' => 'span12',
		);
		
		//create the block
		parent::__construct('pxs_steps_block', $block_options);
	}
	
	function form($instance) {
	
		global $op_background;
		global $op_break_layout_new;
		
		$defaults = array(
			'text' => '',
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>

		<!-- Added Code -->


		<div class="block-settings-title">
			<h4><?php  _e('Parallax Background', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('parallax_layout') ?>">
				<h4 class="label"><?php  _e('Select a layout', 'pxs'); ?></h4>
				<?php echo aq_field_select('parallax_layout', $block_id, $op_break_layout_new, $parallax_layout) ?>
			</label>
		</p>

		<!-- Added Code -->
		
		<div class="block-settings-title">
			<h4><?php  _e('1. Fill in the contents for this section', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title') ?>" class="input-full" type="text" value="<?php echo $title ?>" name="<?php echo $this->get_field_name('title') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('text') ?>">
				<h4 class="label"><?php  _e('Content', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('text') ?>" class="textarea-full" name="<?php echo $this->get_field_name('text') ?>" rows="5"><?php echo $text ?></textarea>
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('Step #1', 'pxs'); ?></h4>
		</div>

		<p class="description">
			<label for="<?php echo $this->get_field_id('title_1') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title_1') ?>" class="input-full" type="text" value="<?php echo $title_1 ?>" name="<?php echo $this->get_field_name('title_1') ?>">
			</label>
			<label for="<?php echo $this->get_field_id('icon_1') ?>">
				<h4 class="label"><?php  _e('Icon', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('icon_1') ?>" class="input-full" type="text" value="<?php echo $icon_1 ?>" name="<?php echo $this->get_field_name('icon_1') ?>">
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('Step #2', 'pxs'); ?></h4>
		</div>

		<p class="description">
			<label for="<?php echo $this->get_field_id('title_2') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title_2') ?>" class="input-full" type="text" value="<?php echo $title_2 ?>" name="<?php echo $this->get_field_name('title_2') ?>">
			</label>
			<label for="<?php echo $this->get_field_id('icon_2') ?>">
				<h4 class="label"><?php  _e('Icon', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('icon_2') ?>" class="input-full" type="text" value="<?php echo $icon_2 ?>" name="<?php echo $this->get_field_name('icon_2') ?>">
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('Step #3', 'pxs'); ?></h4>
		</div>

		<p class="description">
			<label for="<?php echo $this->get_field_id('title_3') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title_3') ?>" class="input-full" type="text" value="<?php echo $title_3 ?>" name="<?php echo $this->get_field_name('title_3') ?>">
			</label>
			<label for="<?php echo $this->get_field_id('icon_3') ?>">
				<h4 class="label"><?php  _e('Icon', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('icon_3') ?>" class="input-full" type="text" value="<?php echo $icon_3 ?>" name="<?php echo $this->get_field_name('icon_3') ?>">
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('2. Section Settings', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('section_name') ?>">
				<h4 class="label"><?php  _e('Section Name eg. Intro', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('section_name') ?>" class="input-full" type="text" value="<?php echo $section_name ?>" name="<?php echo $this->get_field_name('section_name') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('bg') ?>">
				<h4 class="label"><?php  _e('Select a background style', 'pxs'); ?></h4>
				<?php echo aq_field_select('bg', $block_id, $op_background, $bg) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('anchor_color') ?>">
				<h4 class="label"><?php  _e('Anchor Color', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('anchor_color') ?>" class="input-color-picker" type="text" value="<?php echo $anchor_color ?>" name="<?php echo $this->get_field_name('anchor_color') ?>">
			</label>
		</p>
		
		<?php
	}
	
	function block($instance) {
		extract($instance);
		
		if ($section_name == ''){
			$section_name =  'steps'. rand();
		}
		$out = '';
		
		$out .= '<div id="'.$section_name.'" class="section steps '.$bg.'" data-colornav="'.$anchor_color.'">';

		if ($parallax_layout == 'parone') {
			$out .= '<div class="parallaxmodule3 parallax parallax-1"><div class="container" data-speed="10" data-type="background">';
		}

		if ($parallax_layout == 'partwo') {
			$out .= '<div class="parallaxmodule3 parallax parallax-2"><div class="container" data-speed="10" data-type="background">';
		}

		if ($parallax_layout == 'parthree') {
			$out .= '<div class="parallaxmodule3 parallax parallax-3"><div class="container" data-speed="10" data-type="background">';
		}

		if ($parallax_layout == 'parfour') {
			$out .= '<div class="parallaxmodule3 parallax parallax-4"><div class="container" data-speed="10" data-type="background">';
		}

		if ($parallax_layout == 'parfive') {
			$out .= '<div class="parallaxmodule3 parallax parallax-5"><div class="container" data-speed="10" data-type="background">';
		}
		
		$out .= '<div class="content">';
		
		$out .= '<div class="info">';
		
			$out .= '<h1>'.do_shortcode(htmlspecialchars_decode($title)).'</h1>';
			$out .= '<p>'.do_shortcode(htmlspecialchars_decode($text)).'</p>';
			
			$out .= '<div class="item aq_span4">';
				$out .= '<div class="icon"><i class="'.$icon_1.'"></i></div>';
				$out .= '<p>'.do_shortcode(htmlspecialchars_decode($title_1)).'</p>';
			$out .= '</div>';
			
			$out .= '<div class="item aq_span4">';
				$out .= '<div class="icon"><i class="'.$icon_2.'"></i></div>';
				$out .= '<p>'.do_shortcode(htmlspecialchars_decode($title_2)).'</p>';
			$out .= '</div>';
			
			$out .= '<div class="item aq_span4">';
				$out .= '<div class="icon"><i class="'.$icon_3.'"></i></div>';
				$out .= '<p>'.do_shortcode(htmlspecialchars_decode($title_3)).'</p>';
			$out .= '</div>';
			
			$out .= '<div class="arrow left">';
				$out .= '<i class="icon-long-arrow-right"></i>';
			$out .= '</div>';
			
			$out .= '<div class="arrow right">';
				$out .= '<i class="icon-long-arrow-right"></i>';
			$out .= '</div>';
		
		$out .= '</div>';
		
		// $out .= '<div class="icon left">';
		// $out .= '<i class="icon-check"></i>';
		// $out .= '</div>';
		
		// $out .= '<div class="icon right">';
		// $out .= '<i class="icon-check"></i>';
		// $out .= '</div>';
		
		$out .= '</div>';

		$out .= '</div></div>';

		$out .= '</div>';
		
		echo $out;
	}
	
}

?>