<?php

/* Snapshot Block */

class PXS_Snapshot_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Snapshot',
			'size' => 'span12',
		);
		
		//create the block
		parent::__construct('pxs_snapshot_block', $block_options);
	}
	
	function form($instance) {
	
		global $op_background;
		
		$defaults = array(
			'text' => '',
		);
		
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>
		
		<div class="block-settings-title">
			<h4><?php  _e('1. Fill in the contents for this section', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('slogan') ?>">
				<h4 class="label"><?php  _e('Slogan', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('slogan') ?>" class="input-full" type="text" value="<?php echo $slogan ?>" name="<?php echo $this->get_field_name('slogan') ?>">
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('Feature #1', 'pxs'); ?></h4>
		</div>

		<p class="description">
			<label for="<?php echo $this->get_field_id('title_1') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title_1') ?>" class="input-full" type="text" value="<?php echo $title_1 ?>" name="<?php echo $this->get_field_name('title_1') ?>">
			</label>
			<label for="<?php echo $this->get_field_id('text_1') ?>">
				<h4 class="label"><?php  _e('Content', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('text_1') ?>" class="textarea-full" name="<?php echo $this->get_field_name('text_1') ?>" rows="3"><?php echo $text_1 ?></textarea>
			</label>
			<p class="description">
				<label for="<?php echo $this->get_field_id('icon_1') ?>">
					<h4 class="label"><?php  _e('Icon', 'pxs'); ?></h4>
					<?php echo aq_field_input('icon_1', $block_id, $icon_1) ?>
				</label>
			</p>
			<label for="<?php echo $this->get_field_id('screen_1') ?>">
				<h4 class="label"><?php  _e('Upload Image', 'pxs'); ?></h4>
				<?php echo aq_field_upload('screen_1', $block_id, $screen_1) ?>
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('Feature #2', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title_2') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title_2') ?>" class="input-full" type="text" value="<?php echo $title_2 ?>" name="<?php echo $this->get_field_name('title_2') ?>">
			</label>
			<label for="<?php echo $this->get_field_id('text_2') ?>">
				<h4 class="label"><?php  _e('Content', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('text_2') ?>" class="textarea-full" name="<?php echo $this->get_field_name('text_2') ?>" rows="3"><?php echo $text_2 ?></textarea>
			</label>
			<p class="description">
				<label for="<?php echo $this->get_field_id('icon_2') ?>">
					<h4 class="label"><?php  _e('Icon', 'pxs'); ?></h4>
					<?php echo aq_field_input('icon_2', $block_id, $icon_2) ?>
				</label>
			</p>
			<label for="<?php echo $this->get_field_id('screen_2') ?>">
				<h4 class="label"><?php  _e('Upload Image', 'pxs'); ?></h4>
				<?php echo aq_field_upload('screen_2', $block_id, $screen_2) ?>
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('Feature #3', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title_3') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title_3') ?>" class="input-full" type="text" value="<?php echo $title_3 ?>" name="<?php echo $this->get_field_name('title_3') ?>">
			</label>
			<label for="<?php echo $this->get_field_id('text_3') ?>">
				<h4 class="label"><?php  _e('Content', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('text_3') ?>" class="textarea-full" name="<?php echo $this->get_field_name('text_3') ?>" rows="3"><?php echo $text_3 ?></textarea>
			</label>
			<p class="description">
				<label for="<?php echo $this->get_field_id('icon_3') ?>">
					<h4 class="label"><?php  _e('Icon', 'pxs'); ?></h4>
					<?php echo aq_field_input('icon_3', $block_id, $icon_3) ?>
				</label>
			</p>
			<label for="<?php echo $this->get_field_id('screen_3') ?>">
				<h4 class="label"><?php  _e('Upload Image', 'pxs'); ?></h4>
				<?php echo aq_field_upload('screen_3', $block_id, $screen_3) ?>
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('Feature #4', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title_4') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title_4') ?>" class="input-full" type="text" value="<?php echo $title_4 ?>" name="<?php echo $this->get_field_name('title_4') ?>">
			</label>
			<label for="<?php echo $this->get_field_id('text_4') ?>">
				<h4 class="label"><?php  _e('Content', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('text_4') ?>" class="textarea-full" name="<?php echo $this->get_field_name('text_4') ?>" rows="3"><?php echo $text_4 ?></textarea>
			</label>
			<p class="description">
				<label for="<?php echo $this->get_field_id('icon_4') ?>">
					<h4 class="label"><?php  _e('Icon', 'pxs'); ?></h4>
					<?php echo aq_field_input('icon_4', $block_id, $icon_4) ?>
				</label>
			</p>
			<label for="<?php echo $this->get_field_id('screen_4') ?>">
				<h4 class="label"><?php  _e('Upload Image', 'pxs'); ?></h4>
				<?php echo aq_field_upload('screen_4', $block_id, $screen_4) ?>
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('2. Section Settings', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('section_name') ?>">
				<h4 class="label"><?php  _e('Section Name eg. Intro', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('section_name') ?>" class="input-full" type="text" value="<?php echo $section_name ?>" name="<?php echo $this->get_field_name('section_name') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('bg') ?>">
				<h4 class="label"><?php  _e('Select a background style', 'pxs'); ?></h4>
				<?php echo aq_field_select('bg', $block_id, $op_background, $bg) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('anchor_color') ?>">
				<h4 class="label"><?php  _e('Anchor Color', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('anchor_color') ?>" class="input-color-picker" type="text" value="<?php echo $anchor_color ?>" name="<?php echo $this->get_field_name('anchor_color') ?>">
			</label>
		</p>
		
		<?php
	}
	
	function block($instance) {
		extract($instance);
		
		//$feature_rz_s1 = aq_resize($screen_1,'',550);
		//$feature_rz_s2 = aq_resize($screen_2,'',550);
		//$feature_rz_s3 = aq_resize($screen_3,'',550);
		//$feature_rz_s4 = aq_resize($screen_4,'',550);

		if ($section_name == ''){
			$section_name =  'snapshot'. rand();
		}
		?>
		
		<div id="<?php echo $section_name ?>" class="section feature snapshot <?php echo $bg; ?>" data-colornav="<?php echo $anchor_color ?>">
			
			<div class="content">
			
				<div class="screens aq_span5 emptyscreen">
					<?php if ($screen_1 != ''){ ?>
					<img class="screen-default" src="<?php echo $screen_1 ?>" alt="<?php echo do_shortcode(htmlspecialchars_decode($title_1)); ?>" style="height:550px" />
                    <?php }
					if ($screen_1 != ''){ ?>
					<img class="screen-1" src="<?php echo $screen_1 ?>" alt="<?php echo do_shortcode(htmlspecialchars_decode($title_1)); ?>" style="height:550px" />
                     <?php }
					if ($screen_2 != ''){ ?>
					<img class="screen-2" src="<?php echo $screen_2 ?>" alt="<?php echo do_shortcode(htmlspecialchars_decode($title_2)); ?>" style="height:550px" />
                     <?php }
					if ($screen_3 != ''){ ?>
					<img class="screen-3" src="<?php echo $screen_3 ?>" alt="<?php echo do_shortcode(htmlspecialchars_decode($title_3)); ?>" style="height:550px" />
                     <?php }
					if ($screen_4 != ''){ ?>
					<img class="screen-4" src="<?php echo $screen_4 ?>" alt="<?php echo do_shortcode(htmlspecialchars_decode($title_4)); ?>" style="height:550px" />
                     <?php } ?>

				</div>
			
				<div class="content aq_span7">
					
					<h1 class="slogan"><?php echo $slogan ?></h1>
					<?php if($text_1 != ""){ ?>
					<div id="module-1" class="module-1 features aq_span5">
						<div class="icon">
							<i class="<?php echo $icon_1; ?>"></i>
						</div>
						
						<div class="info">
							<h2><?php echo do_shortcode(htmlspecialchars_decode($title_1)); ?></h2>
							<p><?php echo wpautop(do_shortcode(htmlspecialchars_decode($text_1))); ?></p>
						</div>
					</div>
					<?php
					}
					
					if($text_2 != ""){
					?>
					<div id="module-2" class="module-2 features aq_span5">
						<div class="icon">
							<i class="<?php echo $icon_2; ?>"></i>
						</div>
						
						<div class="info">
							<h2><?php echo do_shortcode(htmlspecialchars_decode($title_2)); ?></h2>
							<p><?php echo wpautop(do_shortcode(htmlspecialchars_decode($text_2))); ?></p>
						</div>
					</div>
						<?php
					}?>
					<div style="clear:both;"></div>
					<?php if($text_3 != "")
					{
					?>
					<div id="module-3" class="module-3 features aq_span5">
						<div class="icon">
							<i class="<?php echo $icon_3; ?>"></i>
						</div>
						
						<div class="info">
							<h2><?php echo do_shortcode(htmlspecialchars_decode($title_3)); ?></h2>
							<p><?php echo wpautop(do_shortcode(htmlspecialchars_decode($text_3))); ?></p>
						</div>
					</div>
						<?php
					}
					
					if($text_4 != ""){
					?>
					<div id="module-4" class="module-4 features aq_span5">
						<div class="icon">
							<i class="<?php echo $icon_4; ?>"></i>
						</div>
						
						<div class="info">
							<h2><?php echo do_shortcode(htmlspecialchars_decode($title_4)); ?></h2>
							<p><?php echo wpautop(do_shortcode(htmlspecialchars_decode($text_4))); ?></p>
						</div>
					</div>
					<?php
					}
					
					?>
				</div>
			
			</div>
		
		</div>
		
		<?php
	}
	
}

?>