<?php 

/* =SLOGAN BLOCK
-------------------------------------------------------------- */

class PXS_Slogan_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Slogan',
			'size' => 'span12'
		);
		
		//create the block
		parent::__construct('pxs_slogan_block', $block_options);
	}
	
	function form($instance) {
		global $heading_size;
		
		$defaults = array(
			'heading' => 'standard'
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>
		<div class="block-settings-title"><i class="icon-align-center"></i><h3><?php  _e('Slogan', 'pxs'); ?></h3></div>

		<p class="description">
			<label for="<?php echo $this->get_field_id('heading') ?>">
				<?php _e('Select a heading size', 'pxs') ?><br/>
				<?php echo aq_field_select('heading', $block_id, $heading_size, $heading) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title') ?>">
				<?php _e('Heading', 'pxs'); ?><br/>
				<?php echo aq_field_input('title', $block_id, $title) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('text') ?>">
				<?php _e('Content (Optional)', 'pxs'); ?><br/>
				<?php echo aq_field_textarea('text', $block_id, $text) ?>
			</label>
		</p>
		
		
		<?php
	}
	
	function block($instance) {
		extract($instance);
		
		$out = '';

	    $out = '<div class="slogan">';
	    	$out .= '<'.$heading.'>' . $title . '</'.$heading.'>'; 
	    
		    if ($text) {
			    $out .= '<p>' . wpautop(do_shortcode(htmlspecialchars_decode($text))) . '</p>'; 
		    }
	    
	    $out .=  '</div>';
	    
	    echo $out;
		
	}
}

?>