<?php
	ob_start(); //correction to error in logging in/out wp-admin -> Warning: Cannot modify header information - headers already sent by

/* Services 2x3 Block */

class PXS_Services_2x3_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Services (2x3)',
			'size' => 'span12',
		);
		
		//create the block
		parent::__construct('pxs_services_2x3_block', $block_options);
	}
	
	function form($instance) {
	
		global $op_background;
		global $op_break_layout_new;

		$defaults = array(
			'text' => '',
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>

		<!-- Added Code -->


		<div class="block-settings-title">
			<h4><?php  _e('Parallax Background', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('parallax_layout') ?>">
				<h4 class="label"><?php  _e('Select a layout', 'pxs'); ?></h4>
				<?php echo aq_field_select('parallax_layout', $block_id, $op_break_layout_new, $parallax_layout) ?>
			</label>
		</p>

		<!-- Added Code -->
		
		<div class="block-settings-title">
			<h4><?php  _e('Service 1', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title1') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title1') ?>" class="input-full" type="text" value="<?php echo $title1 ?>" name="<?php echo $this->get_field_name('title1') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('module1_icon') ?>">
				<h4 class="label"><?php  _e('Icon', 'pxs'); ?></h4>
				<?php echo aq_field_upload('module1_icon', $block_id, $module1_icon) ?>
			</label>
		</p>

		<p class="description">
			<label for="<?php echo $this->get_field_id('button_link1') ?>">
				<h4 class="label"><?php  _e('Link', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('button_link1') ?>" class="input-full" type="text" value="<?php echo $button_link1 ?>" name="<?php echo $this->get_field_name('button_link1') ?>">
			</label>
		</p>

		<div class="block-settings-title">
			<h4><?php  _e('Service 2', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title2') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title2') ?>" class="input-full" type="text" value="<?php echo $title2 ?>" name="<?php echo $this->get_field_name('title2') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('module2_icon') ?>">
				<h4 class="label"><?php  _e('Icon', 'pxs'); ?></h4>
				<?php echo aq_field_upload('module2_icon', $block_id, $module2_icon) ?>
			</label>
		</p>

		<p class="description">
			<label for="<?php echo $this->get_field_id('button_link2') ?>">
				<h4 class="label"><?php  _e('Link', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('button_link2') ?>" class="input-full" type="text" value="<?php echo $button_link2 ?>" name="<?php echo $this->get_field_name('button_link2') ?>">
			</label>
		</p>

		<div class="block-settings-title">
			<h4><?php  _e('Service 3', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title3') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title3') ?>" class="input-full" type="text" value="<?php echo $title3 ?>" name="<?php echo $this->get_field_name('title3') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('module3_icon') ?>">
				<h4 class="label"><?php  _e('Icon', 'pxs'); ?></h4>
				<?php echo aq_field_upload('module3_icon', $block_id, $module3_icon) ?>
			</label>
		</p>

		<p class="description">
			<label for="<?php echo $this->get_field_id('button_link3') ?>">
				<h4 class="label"><?php  _e('Link', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('button_link3') ?>" class="input-full" type="text" value="<?php echo $button_link3 ?>" name="<?php echo $this->get_field_name('button_link3') ?>">
			</label>
		</p>

		<div class="block-settings-title">
			<h4><?php  _e('Service 4', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title4') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title4') ?>" class="input-full" type="text" value="<?php echo $title4 ?>" name="<?php echo $this->get_field_name('title4') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('module4_icon') ?>">
				<h4 class="label"><?php  _e('Icon', 'pxs'); ?></h4>
				<?php echo aq_field_upload('module4_icon', $block_id, $module4_icon) ?>
			</label>
		</p>

		<p class="description">
			<label for="<?php echo $this->get_field_id('button_link4') ?>">
				<h4 class="label"><?php  _e('Link', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('button_link4') ?>" class="input-full" type="text" value="<?php echo $button_link4 ?>" name="<?php echo $this->get_field_name('button_link4') ?>">
			</label>
		</p>

		<div class="block-settings-title">
			<h4><?php  _e('Service 5', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title5') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title5') ?>" class="input-full" type="text" value="<?php echo $title5 ?>" name="<?php echo $this->get_field_name('title5') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('module5_icon') ?>">
				<h4 class="label"><?php  _e('Icon', 'pxs'); ?></h4>
				<?php echo aq_field_upload('module5_icon', $block_id, $module5_icon) ?>
			</label>
		</p>

		<p class="description">
			<label for="<?php echo $this->get_field_id('button_link5') ?>">
				<h4 class="label"><?php  _e('Link', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('button_link5') ?>" class="input-full" type="text" value="<?php echo $button_link5 ?>" name="<?php echo $this->get_field_name('button_link5') ?>">
			</label>
		</p>

		<div class="block-settings-title">
			<h4><?php  _e('Service 6', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title6') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title6') ?>" class="input-full" type="text" value="<?php echo $title6 ?>" name="<?php echo $this->get_field_name('title6') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('module6_icon') ?>">
				<h4 class="label"><?php  _e('Icon', 'pxs'); ?></h4>
				<?php echo aq_field_upload('module6_icon', $block_id, $module6_icon) ?>
			</label>
		</p>

		<p class="description">
			<label for="<?php echo $this->get_field_id('button_link6') ?>">
				<h4 class="label"><?php  _e('Link', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('button_link6') ?>" class="input-full" type="text" value="<?php echo $button_link6 ?>" name="<?php echo $this->get_field_name('button_link6') ?>">
			</label>
		</p>

		<?php
	}
	
	function block($instance) {
		extract($instance);
		
		if ($section_name == ''){
			$section_name =  'services-2x3a'. rand();
		}
		//$feature_rz = aq_resize($feature_img,850);
		
		$out = '';
		$out .= '<div id="'.$section_name.'" class="section services '.$bg.'" data-colornav="'.$anchor_color.'" style="padding-top:25px;padding-bottom:25px;" data-speed="10" data-type="background">';

		if ($parallax_layout == 'parone') {
			$out .= '<div class="parallaxmodule2 parallax parallax-1"><div class="container">';
		}

		if ($parallax_layout == 'partwo') {
			$out .= '<div class="parallaxmodule2 parallax parallax-2"><div class="container">';
		}

		if ($parallax_layout == 'parthree') {
			$out .= '<div class="parallaxmodule2 parallax parallax-3"><div class="container">';
		}

		if ($parallax_layout == 'parfour') {
			$out .= '<div class="parallaxmodule2 parallax parallax-4"><div class="container">';
		}

		if ($parallax_layout == 'parfive') {
			$out .= '<div class="parallaxmodule2 parallax parallax-5"><div class="container">';
		}

		$out .= '<div class="content" style="margin: 0 auto; width: 750px; position: relative;">';
		
		$out .= '<div style="text-align: center; width: 750px;margin-top:52px;">';
		
		$out .= '<div id="smodule-1" class="services-2x3" style="background: url(wp-content/themes/instaportfoliopro/img/service-block-1.png); background-repeat: no-repeat">';
		$out .= '<span class="service_helper2"></span><img src="'.$module1_icon.'" /><h1>'.$title1.'</h1>';
		$out .= '</div>';
		$out .= '<div id="smodule-2" class="services-2x3" style="background: url(wp-content/themes/instaportfoliopro/img/service-block-2.png); background-repeat: no-repeat">';
		$out .= '<span class="service_helper2"></span><img src="'.$module2_icon.'" /><h1>'.$title2.'</h1>';
		$out .= '</div>';
		$out .= '<div id="smodule-3" class="services-2x3" style="background: url(wp-content/themes/instaportfoliopro/img/service-block-3.png); background-repeat: no-repeat">';
		$out .= '<span class="service_helper2"></span><img src="'.$module3_icon.'" /><h1>'.$title3.'</h1>';
		$out .= '</div>';
		$out .= '<div style="clear:both;"></div>';
		$out .= '<div id="smodule-4" class="services-2x3" style="background: url(wp-content/themes/instaportfoliopro/img/service-block-4.png); background-repeat: no-repeat">';
		$out .= '<span class="service_helper2"></span><img src="'.$module4_icon.'" /><h1>'.$title4.'</h1>';
		$out .= '</div>';
		$out .= '<div id="smodule-5" class="services-2x3" style="background: url(wp-content/themes/instaportfoliopro/img/service-block-5.png); background-repeat: no-repeat">';
		$out .= '<span class="service_helper2"></span><img src="'.$module5_icon.'" /><h1>'.$title5.'</h1>';
		$out .= '</div>';
		$out .= '<div id="smodule-6" class="services-2x3" style="background: url(wp-content/themes/instaportfoliopro/img/service-block-6.png); background-repeat: no-repeat">';
		$out .= '<span class="service_helper2"></span><img src="'.$module6_icon.'" /><h1>'.$title6.'</h1>';
		$out .= '</div>';

		$out .= '</div>';

		$out .= '</div>';

		$out .= '</div></div>';

		$out .= '</div>';
		
		echo $out;
	}
	
}

?>	