<?php

/* Section Breaker Block */

class PXS_Section_Breaker_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Section Breaker',
			'size' => 'span12',
		);
		
		//create the block
		parent::__construct('pxs_section_breaker_block', $block_options);
	}
	
	function form($instance) {
	
		global $op_break_layout;
		
		$defaults = array(
			'text' => '',
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>
		
		<div class="block-settings-title">
			<h4><?php  _e('Use this block as a section breaker', 'pxs'); ?></h4>
		</div>

		<p class="description">
			<label for="<?php echo $this->get_field_id('header') ?>">
				<h4 class="label"><?php  _e('Header', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('header') ?>" class="input-full" type="text" value="<?php echo $header ?>" name="<?php echo $this->get_field_name('header') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('layout') ?>">
				<h4 class="label"><?php  _e('Select a layout', 'pxs'); ?></h4>
				<?php echo aq_field_select('layout', $block_id, $op_break_layout, $layout) ?>
			</label>
		</p>

		<?php
	}
	
	function block($instance) {
		extract($instance);
		
		$out = '';

		if(!$header) {
			$header = "Parallax";
		}
		
		if ($layout == 'std') {
			$out .= '<div class="breaker">';
			$out .= '<div class="background"></div>';
		}
		
		if ($layout == 'alt') {
			$out .= '<div class="breaker alt">';
			$out .= '<div class="background alt"></div>';
		}
		
		if ($layout == 'std_flip') {
			$out .= '<div class="breaker">';
			$out .= '<div class="background flip"></div>';
		}
		
		if ($layout == 'alt_flip') {
			$out .= '<div class="breaker alt">';
			$out .= '<div class="background alt flip"></div>';
		}

		if ($layout == 'parone') {
			$out .= '<div class="breaker" style="padding-top:25px;padding-bottom:25px;" data-speed="10" data-type="background">';			
			$out .= '<div class="parallaxmodule parallax parallax-1"><div class="container"><h1>'.$header.'</h1></div></div>';
		}

		if ($layout == 'partwo') {
			$out .= '<div class="breaker" style="padding-top:25px;padding-bottom:25px;" data-speed="10" data-type="background">';			
			$out .= '<div class="parallaxmodule parallax parallax-2"><div class="container"><h1>'.$header.'</h1></div></div>';
		}

		if ($layout == 'parthree') {
			$out .= '<div class="breaker" style="padding-top:25px;padding-bottom:25px;" data-speed="10" data-type="background">';			
			$out .= '<div class="parallaxmodule parallax parallax-3"><div class="container"><h1>'.$header.'</h1></div></div>';
		}

		if ($layout == 'parfour') {
			$out .= '<div class="breaker" style="padding-top:25px;padding-bottom:25px;" data-speed="10" data-type="background">';			
			$out .= '<div class="parallaxmodule parallax parallax-4"><div class="container"><h1>'.$header.'</h1></div></div>';
		}

		if ($layout == 'parfive') {
			$out .= '<div class="breaker" style="padding-top:25px;padding-bottom:25px;" data-speed="10" data-type="background">';			
			$out .= '<div class="parallaxmodule parallax parallax-5"><div class="container"><h1>'.$header.'</h1></div></div>';
		}

		if ($layout == 'imgbone') {
			$out .= '<div class="breaker">';			
			$out .= '<div class="imgsecone"></div>';
		}

		if ($layout == 'imgbtwo') {
			$out .= '<div class="breaker">';			
			$out .= '<div class="imgsectwo"></div>';
		}
			
			
		$out .= '</div>';
		
		echo $out;
	}
	
}

?>