<?php

/* Purchase Image Button Block */

class PXS_Purchase_Image_Button_Block extends AQ_Block {

	//set and create block

	function __construct() {

		$block_options = array(

			'name' => 'Purchase with Image Button',

			'size' => 'span12',

		);

		//create the block

		parent::__construct('pxs_purchase_image_button_block', $block_options);

	}

	function form($instance) {

		global $op_background;

		$defaults = array(

			'text' => '',

		);

		$instance = wp_parse_args($instance, $defaults);

		extract($instance);




		?>




		<div class="block-settings-title">

			<h4><?php  _e('1. Fill in the contents for this section', 'pxs'); ?></h4>

		</div>




		<p class="description">

			<label for="<?php echo $this->get_field_id('title') ?>">

				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>

				<input id="<?php echo $this->get_field_id('title') ?>" class="input-full" type="text" value="<?php echo $title ?>" name="<?php echo $this->get_field_name('title') ?>">

			</label>

		</p>




		<p class="description">

			<label for="<?php echo $this->get_field_id('text') ?>">

				<h4 class="label"><?php  _e('Content', 'pxs'); ?></h4>

				<textarea id="<?php echo $this->get_field_id('text') ?>" class="textarea-full" name="<?php echo $this->get_field_name('text') ?>" rows="5"><?php echo $text ?></textarea>

			</label>

		</p>

		<p class="description">

			<label for="<?php echo $this->get_field_id('button_image') ?>">

				<h4 class="label"><?php  _e('Button Image', 'pxs'); ?></h4>

				<?php echo aq_field_upload('button_image', $block_id, $button_image) ?>

			</label>

		</p>




		<p class="description">

			<label for="<?php echo $this->get_field_id('button_link') ?>">

				<h4 class="label"><?php  _e('Link', 'pxs'); ?></h4>

				<input id="<?php echo $this->get_field_id('button_link') ?>" class="input-full" type="text" value="<?php echo $button_link ?>" name="<?php echo $this->get_field_name('button_link') ?>">

			</label>

		</p>




		<div class="block-settings-title">

			<h4><?php  _e('2. Section Settings', 'pxs'); ?></h4>

		</div>




		<p class="description">

			<label for="<?php echo $this->get_field_id('section_name') ?>">

				<h4 class="label"><?php  _e('Section Name eg. Intro', 'pxs'); ?></h4>

				<input id="<?php echo $this->get_field_id('section_name') ?>" class="input-full" type="text" value="<?php echo $section_name ?>" name="<?php echo $this->get_field_name('section_name') ?>">

			</label>

		</p>




		<p class="description">

			<label for="<?php echo $this->get_field_id('bg') ?>">

				<h4 class="label"><?php  _e('Select a background style', 'pxs'); ?></h4>

				<?php echo aq_field_select('bg', $block_id, $op_background, $bg) ?>

			</label>

		</p>




		<p class="description">

			<label for="<?php echo $this->get_field_id('anchor_color') ?>">

				<h4 class="label"><?php  _e('Anchor Color', 'pxs'); ?></h4>

				<input id="<?php echo $this->get_field_id('anchor_color') ?>" class="input-color-picker" type="text" value="<?php echo $anchor_color ?>" name="<?php echo $this->get_field_name('anchor_color') ?>">

			</label>

		</p>




		<?php

	}



	function block($instance) {

		extract($instance);




		if ($section_name == ''){

			$section_name =  'purchase-image-button'. rand();

		}

		$out = '';

		$out .= '<div id="'.$section_name.'" class="section purchase-image-button '.$bg.'" data-colornav="'.$anchor_color.'">';

		$out .= '<div class="content" style="margin: 0 auto; width: 750px; position: relative;">';

		$out .= '<div class="info" style="background: url(wp-content/themes/videoportfoliopro-o/img/two-column-block-1.png);">';

		$out .= '<h1>'.do_shortcode(htmlspecialchars_decode($title)).'</h1>';

		$out .= '<h3>'.do_shortcode(htmlspecialchars_decode($text)).'</h3>';

		$out .= "</div>";

		$out .= '<div class="image" style="background: url(wp-content/themes/videoportfoliopro-o/img/two-column-block-2.png);">';

		$out .= '<span class="service_helper2"></span>';

		$out .= '<a href="'.$button_link.'"><img class="img" src="'.$button_image.'"/></a>';

		$out .= '</div>';

		$out .= "</div>";

		$out .= "</div>";

		echo $out;

	}



}

?>