<?php

class PXS_Pricing_Table_Block extends AQ_Block {

	function __construct() {
		$block_options = array(
			'name'  => 'Pricing Table',
			'size'  => 'span4'
		);
		
		parent::__construct('pxs_pricing_table_block', $block_options);
		add_action('wp_ajax_aq_block_ptable_add_new', array($this, 'add_ptable'));
	}

	function form($instance) {
		global $heading_size;

		$defaults = array(
			'ptables' => array(
				1 => array(
					'title'   => 'Bullet',
					'content'  => 'Live Support 24/7',
				)
			)
		);
		
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		?>
		<p class="description">
			<label for="<?php echo $this->get_field_id('title') ?>">
				<h4 class="label"><?php  _e('Package Title', 'pxs'); ?></h4>
				<?php echo aq_field_input('title', $block_id, $title) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('label') ?>">
				<h4 class="label"><?php  _e('Label eg. 20% Discount (Optional)', 'pxs'); ?></h4>
				<?php echo aq_field_input('label', $block_id, $label) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('price') ?>">
				<h4 class="label"><?php  _e('Price', 'pxs'); ?></h4>
				<?php echo aq_field_input('price', $block_id, $price) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('timeline') ?>">
				<h4 class="label"><?php  _e('Timeline eg. /month', 'pxs'); ?></h4>
				<?php echo aq_field_input('timeline', $block_id, $timeline) ?>
			</label>
		</p>
		
		<div class="description">
			<h4 class="label"><?php  _e('Add Bullet', 'pxs'); ?></h4>
			<ul id="sortable-list-<?php echo $block_id ?>" class="aq-sortable-list" rel="<?php echo $block_id ?>">
				<?php
				$ptables = is_array($ptables) ? $ptables : $defaults['ptables'];
				$count = 1;
				foreach ($ptables as $ptable) {	
					$this->slide($ptable, $count);
					$count++;
				}
				?>
			</ul>
			<p></p>
			<a href="#" rel="ptable" class="aq-sortable-add-new button">Add New</a>
			<p></p>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('button_text') ?>">
				<h4 class="label"><?php  _e('Button Text', 'pxs'); ?></h4>
				<?php echo aq_field_input('button_text', $block_id, $button_text) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('link') ?>">
				<h4 class="label"><?php  _e('Button Link', 'pxs'); ?></h4>
				<?php echo aq_field_input('link', $block_id, $link) ?>
			</label>
		</p>
		
	<?php }

	function slide($ptable = array(), $count = 0) {
		
		$defaults = array (
			'title'   => 'Bullet',
			'content'  => 'Live Support 24/7',
		);

		$ptable = wp_parse_args($ptable, $defaults); 
		?>

		<li id="<?php echo $this->get_field_id('ptables') ?>-sortable-item-<?php echo $count ?>" class="sortable-item" rel="<?php echo $count ?>">
			<div class="sortable-head cf">
				<div class="sortable-title">
					<strong><?php echo $ptable['title'] ?></strong>
				</div>
				<div class="sortable-handle">
					<a href="#"><?php _e('Open / Close', 'pxs'); ?></a>
				</div>
			</div>
			
			<div class="sortable-body">
				<p class="description">
					<label for="<?php echo $this->get_field_id('ptables') ?>-<?php echo $count ?>-content">
						Content<br/>
						<textarea id="<?php echo $this->get_field_id('ptables') ?>-<?php echo $count ?>-content" class="textarea-full" name="<?php echo $this->get_field_name('ptables') ?>[<?php echo $count ?>][content]" rows="3"><?php echo $ptable['content'] ?></textarea>
					</label>
				</p>
				<p class="description"><a href="#" class="sortable-delete"><?php _e('Delete', 'pxs'); ?></a></p>
			</div>
			
		</li>
	<?php }

	function add_ptable() {
		$nonce = $_POST['security'];	
		if (!wp_verify_nonce($nonce, 'aqpb-settings-page-nonce') ) die('-1');
		
		$count = isset($_POST['count']) ? absint($_POST['count']) : false;
		$this->block_id = isset($_POST['block_id']) ? $_POST['block_id'] : 'aq-block-9999';
		
		$ptable = array(
			'title'   => 'Bullet',
			'content'  => 'Live Support 24/7',
		);
		
		if ($count) {
			$this->slide($ptable, $count);
		} else {
			die(-1);
		}
		
		die();
	}

	function block($instance) {
		extract($instance);
		
		$out = '';
		
		 $out .= '<ul class="pricing-table">';
	    	$out .= '<li class="title"><h2>'.$title.'</h2>';
	    	if($label) $out .= '<span class="label">'.$label.'</span>';
	    	$out .= '</li>';
	    	$out .= '<li class="price">'.$price.'<span class="timeline">'.$timeline.'</span></li>';
				foreach ($ptables as $ptable) {
				    $out .= '<li class="bullet">' . $ptable['content'] . '</li>';
			    }
			$out .= '<li class="cta"><a href="'.$link.'">'.$button_text.'</a></li>';
	    $out .= '</ul>';
		
		echo $out;
		
	 }
	
	function update($new_instance, $old_instance) {
		$new_instance = aq_recursive_sanitize($new_instance);
		return $new_instance;
	}
	
}
