<?php

/* Newsletter Block */

class PXS_Newsletter_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Newsletter',
			'size' => 'span12',
		);
		
		//create the block
		parent::__construct('pxs_newsletter_block', $block_options);
	}
	
	function form($instance) {
	
		global $op_background;
		
		$defaults = array(
			'text' => '',
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>
		
		<div class="block-settings-title">
			<h4><?php  _e('1. Fill in the contents for this section', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title') ?>" class="input-full" type="text" value="<?php echo $title ?>" name="<?php echo $this->get_field_name('title') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('text') ?>">
				<h4 class="label"><?php  _e('Content', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('text') ?>" class="textarea-full" name="<?php echo $this->get_field_name('text') ?>" rows="5"><?php echo $text ?></textarea>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('placeholder') ?>">
				<h4 class="label"><?php  _e('Placeholder eg. Enter email address', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('placeholder') ?>" class="input-full" type="text" value="<?php echo $placeholder ?>" name="<?php echo $this->get_field_name('placeholder') ?>">
			</label>
		</p>

		<p class="description">
			<label for="<?php echo $this->get_field_id('button_text') ?>">
				<h4 class="label"><?php  _e('Button Text', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('button_text') ?>" class="input-full" type="text" value="<?php echo $button_text ?>" name="<?php echo $this->get_field_name('button_text') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('button_link') ?>">
				<h4 class="label"><?php  _e('Button Link', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('button_link') ?>" class="input-full" type="text" value="<?php echo $button_link ?>" name="<?php echo $this->get_field_name('button_link') ?>">
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('2. Section Settings', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('section_name') ?>">
				<h4 class="label"><?php  _e('Section Name eg. Intro', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('section_name') ?>" class="input-full" type="text" value="<?php echo $section_name ?>" name="<?php echo $this->get_field_name('section_name') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('bg') ?>">
				<h4 class="label"><?php  _e('Select a background style', 'pxs'); ?></h4>
				<?php echo aq_field_select('bg', $block_id, $op_background, $bg) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('anchor_color') ?>">
				<h4 class="label"><?php  _e('Anchor Color', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('anchor_color') ?>" class="input-color-picker" type="text" value="<?php echo $anchor_color ?>" name="<?php echo $this->get_field_name('anchor_color') ?>">
			</label>
		</p>
		
		<?php
	}
	
	function block($instance) {
		extract($instance);
		if ($section_name == ''){
			$section_name =  'newsletter'. rand();
		}
		
		$out = '';
		
		$out .= '<div id="'.$section_name.'" class="section newsletter '.$bg.'" data-colornav="'.$anchor_color.'">';
		
		$out .= '<div class="content">';
		
		$out .= '<div class="info">';
		$out .= '<h1>'.do_shortcode(htmlspecialchars_decode($title)).'</h1>';
		$out .= '<p>'.do_shortcode(htmlspecialchars_decode($text)).'</p>';
		$out .= '<input type="text" placeholder="'.$placeholder.'" />';
		$out .= '<a href="'.$button_link.'">'.do_shortcode(htmlspecialchars_decode($button_text)).'</a>';
		$out .= "</div>";
		
		$out .= '<div class="icon left">';
		$out .= '<i class="icon-file-text-alt"></i>';
		$out .= '</div>';
		
		$out .= '<div class="icon right">';
		$out .= '<i class="icon-file-text-alt"></i>';
		$out .= '</div>';
		
		$out .= "</div>";
			
		$out .= "</div>";
		
		echo $out;
	}
	
}

?>