<?php

/* =GOOGLE MAPS BLOCK
-------------------------------------------------------------- */

class PXS_Map_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Google Map',
			'size' => 'span12'
		);
		
		//create the block
		parent::__construct('pxs_map_block', $block_options);
	}
	
	function form($instance) {
		global $heading_size;
		
		$defaults = array(
			'coor' => '-34.397, 150.644',
			'info' => 'We are located opposite of Green Way street',
			'zoom' => '5',
			'width' => '1140',
			'height' => '350'
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>
		
		<div class="block-settings-title"><i class="icon-map-marker"></i><h3><?php  _e('Google Map', 'pxs'); ?></h3></div>

		<div class="description">
			<label for="<?php echo $this->get_field_id('lat') ?>">
				<?php _e('Latitude Eg. -34.397', 'pxs') ?>
				<?php echo aq_field_input('lat', $block_id, $lat) ?>
			</label>
		</div>
		
		<div class="description">
			<label for="<?php echo $this->get_field_id('lng') ?>">
				<?php _e('Longitude Eg. 150.644', 'pxs') ?>
				<?php echo aq_field_input('lng', $block_id, $lng) ?>
			</label>
		</div>
		
		<div class="description">
			<label for="<?php echo $this->get_field_id('address') ?>">
				<?php _e('Address (not for map location)', 'pxs') ?>
				<?php echo aq_field_textarea('address', $block_id, $address) ?>
			</label>
		</div>
		
		<div class="description">
			<label for="<?php echo $this->get_field_id('info') ?>">
				<?php _e('Marker Infowindow content', 'pxs') ?>
				<?php echo aq_field_textarea('info', $block_id, $info) ?>
			</label>
		</div>

		<div class="description">
			<label for="<?php echo $this->get_field_id('zoom') ?>">
				<?php _e('Zoom Level', 'pxs') ?>
				<?php echo aq_field_input('zoom', $block_id, $zoom) ?>
			</label>
		</div>

		<div class="description">
			<label for="<?php echo $this->get_field_id('height') ?>">
				<?php _e('Height', 'pxs') ?>
				<?php echo aq_field_input('height', $block_id, $height) ?>
			</label>
		</div>

		<?php
		
	}
	
	function block($instance) {
		extract($instance);
		
		$out = '';
		$mid = rand(5, 15);
		$mapid = 'map-canvas-' . $mid;

		$data = array('lat' => $lat, 'lng' => $lng, 'info' => $info, 'zoom' => $zoom, 'mapid' => $mid, );
		if(!empty($data)) {
			
			wp_enqueue_script('google-maps-api', 'https://maps.googleapis.com/maps/api/js?v=3.exp&sensor=false');
			wp_register_script('google-maps',  get_template_directory_uri() . '/js/gmaps.js', array('jquery'), '20131010', true);
			wp_enqueue_script('google-maps');	
	
			wp_localize_script('google-maps', 'php_data', $data);
		}
		
		$out .= '<div class="map">';
			
			$out .= '<div class="address">';
				$out .= '<h4>'.$address.'</h4>';
			$out .= '</div>';
			
		
			$out .= '<div id="map-canvas-'.$mid.'" class="map-canvas" style="height:'.$height.'px;"></div>';
			
			
		$out .= '</div>';	
		
		echo $out;
		
	}
	
}
