<?php

/* Introduction Video Block */

class PXS_Intro_Video_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Introduction Video',
			'size' => 'span12',
		);
		
		//create the block
		parent::__construct('pxs_intro_video_block', $block_options);
	}
	
	function form($instance) {
	
		global $op_background;
		
		$defaults = array(
			'text' => '',
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>

		<div class="block-settings-title">
			<h4><?php  _e('1. Videos (embed codes)', 'pxs'); ?></h4>
		</div>

		<p class="description">
			<label for="<?php echo $this->get_field_id('module1_video') ?>">
				<h4 class="label"><?php  _e('Video 1', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('module1_video') ?>" class="textarea-full" name="<?php echo $this->get_field_name('module1_video') ?>" rows="3"><?php echo $module1_video ?></textarea>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('module2_video') ?>">
				<h4 class="label"><?php  _e('Video 2', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('module2_video') ?>" class="textarea-full" name="<?php echo $this->get_field_name('module2_video') ?>" rows="3"><?php echo $module2_video ?></textarea>
			</label>
		</p>

		<p class="description">
			<label for="<?php echo $this->get_field_id('module3_video') ?>">
				<h4 class="label"><?php  _e('Video 3', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('module3_video') ?>" class="textarea-full" name="<?php echo $this->get_field_name('module3_video') ?>" rows="3"><?php echo $module3_video ?></textarea>
			</label>
		</p>

		<p class="description">
			<label for="<?php echo $this->get_field_id('module4_video') ?>">
				<h4 class="label"><?php  _e('Video 4', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('module4_video') ?>" class="textarea-full" name="<?php echo $this->get_field_name('module4_video') ?>" rows="3"><?php echo $module4_video ?></textarea>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('module5_video') ?>">
				<h4 class="label"><?php  _e('Video 5', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('module5_video') ?>" class="textarea-full" name="<?php echo $this->get_field_name('module5_video') ?>" rows="3"><?php echo $module5_video ?></textarea>
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('2. Fill in the contents for this section', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title1') ?>">
				<h4 class="label"><?php  _e('Title 1', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title1') ?>" class="input-full" type="text" value="<?php echo $title1 ?>" name="<?php echo $this->get_field_name('title1') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('headline1') ?>">
				<h4 class="label"><?php  _e('Content 1', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('headline1') ?>" class="textarea-full" name="<?php echo $this->get_field_name('headline1') ?>" rows="3"><?php echo $headline1 ?></textarea>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title2') ?>">
				<h4 class="label"><?php  _e('Title 2', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title2') ?>" class="input-full" type="text" value="<?php echo $title2 ?>" name="<?php echo $this->get_field_name('title2') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('headline2') ?>">
				<h4 class="label"><?php  _e('Content 2', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('headline2') ?>" class="textarea-full" name="<?php echo $this->get_field_name('headline2') ?>" rows="3"><?php echo $headline2 ?></textarea>
			</label>
		</p>
		

		<div class="block-settings-title">
			<h4><?php  _e('3. Section Settings', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('section_name') ?>">
				<h4 class="label"><?php  _e('Section Name eg. Intro', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('section_name') ?>" class="input-full" type="text" value="<?php echo $section_name ?>" name="<?php echo $this->get_field_name('section_name') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('bg') ?>">
				<h4 class="label"><?php  _e('Select a background style', 'pxs'); ?></h4>
				<?php echo aq_field_select('bg', $block_id, $op_background, $bg) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('anchor_color') ?>">
				<h4 class="label"><?php  _e('Anchor Color', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('anchor_color') ?>" class="input-color-picker" type="text" value="<?php echo $anchor_color ?>" name="<?php echo $this->get_field_name('anchor_color') ?>">
			</label>
		</p>
		
		<?php
	}

	public function getImageURL($string = '') {
		$result = '';
		if (strlen($string) > 0) {
			//try new embed code
			if (strpos($string, 'vimeo') !== false) {
				preg_match('/https:\/\/player.vimeo.com\/video\/([^?"]*)/is', $string, $match); 
				$id = $match[1];
				$url = 'http://vimeo.com/api/v2/video/'.$id.'.json';
				//curl request
				$curl = curl_init();
				curl_setopt($curl, CURLOPT_URL, $url);
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
				$curlData = curl_exec($curl);
				curl_close($curl);

				//decoding json structure into array
				$arr = current(json_decode($curlData, true));

				$result = '<img src="'.$arr["thumbnail_medium"].'" style="max-height: 50px; max-width: 80px;"/>';

			}
			else {
				preg_match('%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i', $string, $match);
			   	$id = $match[1];
				$url = 'http://img.youtube.com/vi/'.trim($id).'/0.jpg';

				$result = '<img src="'.$url.'" style="max-height: 50px; max-width: 80px;"/>';
				
			}				

		}
		return $result;
	}
	
	function block($instance) {
		extract($instance);
		
		if ($section_name == ''){
			$block_num = rand();
			$section_name =  'intro-video'. $block_num;
		}
		//$feature_rz = aq_resize($feature_img,850);
		
		$out = '';
		
		$out .= '<div id="'.$section_name.'" class="section introduction-video '.$bg.'" data-colornav="'.$anchor_color.'">';
		
		$out .= '<div class="content">';
		
		$out .= '<div class="video" id="video-main'.$block_num.'">';
		$out .= htmlspecialchars_decode($module1_video); 
		$out .= '</div>';

		$out .= '<div class="info2">';

		$out .= '<h1>'.do_shortcode(htmlspecialchars_decode($title1)).'</h1>';
		$out .= '<h3>'.do_shortcode(htmlspecialchars_decode($headline1)).'</h3>';
		$out .= '<h1>'.do_shortcode(htmlspecialchars_decode($title2)).'</h1>';
		$out .= '<h3>'.do_shortcode(htmlspecialchars_decode($headline2)).'</h3>';

		$out .= '<div class="video-src" onclick="changeVideo'.$block_num.'a()">'.$this->getImageURL($module1_video).'</div>';
		$out .= '<div class="video-src" onclick="changeVideo'.$block_num.'b()">'.$this->getImageURL($module2_video).'</div>';
		$out .= '<div class="video-src" onclick="changeVideo'.$block_num.'c()">'.$this->getImageURL($module3_video).'</div>';
		$out .= '<div class="video-src" onclick="changeVideo'.$block_num.'d()">'.$this->getImageURL($module4_video).'</div>';
		$out .= '<div class="video-src" onclick="changeVideo'.$block_num.'e()">'.$this->getImageURL($module5_video).'</div>';

		$out .= '</div>';
		
		$out .= '</div>';
			
		$out .= '</div>';

		$out .= '<script type="text/javascript" charset="utf-8">';
    	$out .= 'function changeVideo'.$block_num.'a() {';
        $out .= 'document.getElementById("video-main'.$block_num.'").innerHTML = \'' .htmlspecialchars_decode($module1_video).'\';';
    	$out .= '}';
    	$out .= 'function changeVideo'.$block_num.'b() {';
        $out .= 'document.getElementById("video-main'.$block_num.'").innerHTML = \'' .htmlspecialchars_decode($module2_video).'\';';
    	$out .= '}';
    	$out .= 'function changeVideo'.$block_num.'c() {';
        $out .= 'document.getElementById("video-main'.$block_num.'").innerHTML = \'' .htmlspecialchars_decode($module3_video).'\';';
    	$out .= '}';
    	$out .= 'function changeVideo'.$block_num.'d() {';
        $out .= 'document.getElementById("video-main'.$block_num.'").innerHTML = \'' .htmlspecialchars_decode($module4_video).'\';';
    	$out .= '}';
    	$out .= 'function changeVideo'.$block_num.'e() {';
        $out .= 'document.getElementById("video-main'.$block_num.'").innerHTML = \'' .htmlspecialchars_decode($module5_video).'\';';
    	$out .= '}';
		$out .= '</script>';
		echo $out;
	}
	
}

?>