<?php

/* Introduction Block */

class PXS_Intro_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Introduction',
			'size' => 'span12',
		);
		
		//create the block
		parent::__construct('pxs_intro_block', $block_options);
	}
	
	function form($instance) {
	
		global $op_background;
		
		$defaults = array(
			'text' => '',
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>
		
		<div class="block-settings-title">
			<h4><?php  _e('1. Fill in the contents for this section', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title') ?>">
				<h4 class="label"><?php  _e('Slogan', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title') ?>" class="input-full" type="text" value="<?php echo $title ?>" name="<?php echo $this->get_field_name('title') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('headline') ?>">
				<h4 class="label"><?php  _e('Content', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('headline') ?>" class="textarea-full" name="<?php echo $this->get_field_name('headline') ?>" rows="3"><?php echo $headline ?></textarea>
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('2. Upload Images', 'pxs'); ?></h4>
		</div>
		
		<p class="description full">
			<label for="<?php echo $this->get_field_id('feature_img') ?>">
				<h4 class="label"><?php  _e('Feature', 'pxs'); ?></h4>
				<?php echo aq_field_upload('feature_img', $block_id, $feature_img) ?>
			</label>
		</p>
		
		<p class="description third">
			<label for="<?php echo $this->get_field_id('module1_img') ?>">
				<h4 class="label"><?php  _e('Module #1', 'pxs'); ?></h4>
				<?php echo aq_field_upload('module1_img', $block_id, $module1_img) ?>
			</label>
		</p>
		
		<p class="description third">
			<label for="<?php echo $this->get_field_id('module2_img') ?>">
				<h4 class="label"><?php  _e('Module #2', 'pxs'); ?></h4>
				<?php echo aq_field_upload('module2_img', $block_id, $module2_img) ?>
			</label>
		</p>
		
		<p class="description third last">
			<label for="<?php echo $this->get_field_id('module3_img') ?>">
				<h4 class="label"><?php  _e('Module #3', 'pxs'); ?></h4>
				<?php echo aq_field_upload('module3_img', $block_id, $module3_img) ?>
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('3. Button Settings', 'pxs'); ?></h4>
		</div>

		<p class="description">
			<label for="<?php echo $this->get_field_id('button_text') ?>">
				<h4 class="label"><?php  _e('Text', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('button_text') ?>" class="input-full" type="text" value="<?php echo $button_text ?>" name="<?php echo $this->get_field_name('button_text') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('button_link') ?>">
				<h4 class="label"><?php  _e('Link', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('button_link') ?>" class="input-full" type="text" value="<?php echo $button_link ?>" name="<?php echo $this->get_field_name('button_link') ?>">
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('4. Section Settings', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('section_name') ?>">
				<h4 class="label"><?php  _e('Section Name eg. Intro', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('section_name') ?>" class="input-full" type="text" value="<?php echo $section_name ?>" name="<?php echo $this->get_field_name('section_name') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('bg') ?>">
				<h4 class="label"><?php  _e('Select a background style', 'pxs'); ?></h4>
				<?php echo aq_field_select('bg', $block_id, $op_background, $bg) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('anchor_color') ?>">
				<h4 class="label"><?php  _e('Anchor Color', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('anchor_color') ?>" class="input-color-picker" type="text" value="<?php echo $anchor_color ?>" name="<?php echo $this->get_field_name('anchor_color') ?>">
			</label>
		</p>
		
		<?php
	}
	
	function block($instance) {
		extract($instance);
		
		if ($section_name == ''){
			$section_name =  'intro'. rand();
		}
		//$feature_rz = aq_resize($feature_img,850);
		
		$out = '';
		
		$out .= '<div id="'.$section_name.'" class="section introduction '.$bg.'" data-colornav="'.$anchor_color.'">';
		
		$out .= '<div class="content">';
		
		$out .= '<div class="info">';
		$out .= '<h1>'.do_shortcode(htmlspecialchars_decode($title)).'</h1>';
		$out .= '<h3>'.do_shortcode(htmlspecialchars_decode($headline)).'</h3>';
		$out .= '<a href="'.$button_link.'">'.do_shortcode(htmlspecialchars_decode($button_text)).'</a>';
		$out .= '</div>';
		
		$out .= '<div class="image">';
		
		$out .= '<div class="module-1">';
		$out .= '<img class="img" src="'.$module1_img.'" alt=""/>';
		$out .= '<img class="focus" src="'.get_template_directory_uri().'/img/focushand.png" alt=""/>';
		$out .= '</div>';
		
		$out .= '<div class="module-2">';
		$out .= '<img class="img" src="'.$module2_img.'" alt=""/>';
		$out .= '<img class="focus" src="'.get_template_directory_uri().'/img/focushand.png" alt=""/>';
		$out .= '</div>';
		
		$out .= '<div class="module-3">';
		$out .= '<img class="img" src="'.$module3_img.'" alt=""/>';
		$out .= '<img class="focus" src="'.get_template_directory_uri().'/img/focushand.png" alt=""/>';
		$out .= '</div>';
		
		$out .= '<img class="feature" src="'.$feature_img.'" alt="'.do_shortcode(htmlspecialchars_decode($title)).'" style="max-width:760px;" />';
		
		$out .= '</div>';
		
		$out .= '</div>';
			
		$out .= '</div>';
		
		echo $out;
	}
	
}

?>