<?php
	ob_start(); //correction to error in logging in/out wp-admin -> Warning: Cannot modify header information - headers already sent by

/* Image Playlist Block */

class PXS_Image_Playlist_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Image Playlist',
			'size' => 'span12',
		);
		
		//create the block
		parent::__construct('pxs_image_playlist_block', $block_options);
	}
	
	function form($instance) {
	
		global $op_background;
		
		$defaults = array(
			'text' => '',
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>

		<div class="block-settings-title">
			<h4><?php  _e('Header', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('header1') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('header1') ?>" class="input-full" type="text" value="<?php echo $header1 ?>" name="<?php echo $this->get_field_name('header1') ?>">
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('Image 1', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title1') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title1') ?>" class="input-full" type="text" value="<?php echo $title1 ?>" name="<?php echo $this->get_field_name('title1') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('headline1') ?>">
				<h4 class="label"><?php  _e('Description', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('headline1') ?>" class="textarea-full" name="<?php echo $this->get_field_name('headline1') ?>" rows="3"><?php echo $headline1 ?></textarea>
			</label>
		</p>

		<p class="description">
			<label for="<?php echo $this->get_field_id('module1_image') ?>">
				<h4 class="label"><?php  _e('Image', 'pxs'); ?></h4>
				<?php echo aq_field_upload('module1_image', $block_id, $module1_image) ?>
			</label>
		</p>				

		<div class="block-settings-title">
			<h4><?php  _e('Image 2', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title2') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title2') ?>" class="input-full" type="text" value="<?php echo $title2 ?>" name="<?php echo $this->get_field_name('title2') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('headline2') ?>">
				<h4 class="label"><?php  _e('Description', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('headline2') ?>" class="textarea-full" name="<?php echo $this->get_field_name('headline2') ?>" rows="3"><?php echo $headline2 ?></textarea>
			</label>
		</p>

		<p class="description">
			<label for="<?php echo $this->get_field_id('module2_image') ?>">
				<h4 class="label"><?php  _e('Image', 'pxs'); ?></h4>
				<?php echo aq_field_upload('module2_image', $block_id, $module2_image) ?>
			</label>
		</p>

		<div class="block-settings-title">
			<h4><?php  _e('Image 3', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title3') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title3') ?>" class="input-full" type="text" value="<?php echo $title3 ?>" name="<?php echo $this->get_field_name('title3') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('headline3') ?>">
				<h4 class="label"><?php  _e('Description', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('headlinee') ?>" class="textarea-full" name="<?php echo $this->get_field_name('headline3') ?>" rows="3"><?php echo $headline3 ?></textarea>
			</label>
		</p>

		<p class="description">
			<label for="<?php echo $this->get_field_id('module3_image') ?>">
				<h4 class="label"><?php  _e('Image', 'pxs'); ?></h4>
				<?php echo aq_field_upload('module3_image', $block_id, $module3_image) ?>
			</label>
		</p>				

		<div class="block-settings-title">
			<h4><?php  _e('Image 4', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title4') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title4') ?>" class="input-full" type="text" value="<?php echo $title4 ?>" name="<?php echo $this->get_field_name('title4') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('headline4') ?>">
				<h4 class="label"><?php  _e('Description', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('headline4') ?>" class="textarea-full" name="<?php echo $this->get_field_name('headline4') ?>" rows="3"><?php echo $headline4 ?></textarea>
			</label>
		</p>

		<p class="description">
			<label for="<?php echo $this->get_field_id('module4_image') ?>">
				<h4 class="label"><?php  _e('Image', 'pxs'); ?></h4>
				<?php echo aq_field_upload('module4_image', $block_id, $module4_image) ?>
			</label>
		</p>
				
		<?php
	}
	
	function block($instance) {
		extract($instance);
		
		if ($section_name == ''){
			$block_num = rand();
			$section_name =  'image-playlist'. $block_num;
		}
		//$feature_rz = aq_resize($feature_img,850);
		
		$out = '';
		$out .= '<div id="'.$section_name.'" class="section image-playlist '.$bg.'" data-colornav="'.$anchor_color.'">';
		$out .= '<div style="width: 100%; text-align: center; margin: 20px;"><h1>'.$header1.'</h1></div>';

		$out .= '<div class="content">';
		$out .= '<div class="info">';
		$out .= '<image class="image2" id="image-main'.$block_num.'" src="'.htmlspecialchars_decode($module1_image).'"/>';

		$out .= "</div>";

		$out .= '<div class="playlist">';

		$out .= '<div class="image-src3" onclick="changeImage'.$block_num.'a()">';
		$out .= '<img class="img'.$block_num.'" id="img'.$block_num.'-src1" src="wp-content/themes/socialvid/img/icon-pause.png"/>';
		$out .= '<h1>'.do_shortcode(htmlspecialchars_decode($title1)).'</h1>';
		$out .= '<p>'.do_shortcode(htmlspecialchars_decode($headline1)).'</p>';
		$out .= '</div>';
		$out .= '<div class="image-src3" onclick="changeImage'.$block_num.'b()">';
		$out .= '<img class="img'.$block_num.'" id="img'.$block_num.'-src2" src="wp-content/themes/socialvid/img/icon-play.png"/>';
		$out .= '<h1>'.do_shortcode(htmlspecialchars_decode($title2)).'</h1>';
		$out .= '<p>'.do_shortcode(htmlspecialchars_decode($headline2)).'</p>';
		$out .= '</div>';
		$out .= '<div class="image-src3" onclick="changeImage'.$block_num.'c()">';
		$out .= '<img class="img'.$block_num.'" id="img'.$block_num.'-src3" src="wp-content/themes/socialvid/img/icon-play.png"/>';
		$out .= '<h1>'.do_shortcode(htmlspecialchars_decode($title3)).'</h1>';
		$out .= '<p>'.do_shortcode(htmlspecialchars_decode($headline3)).'</p>';
		$out .= '</div>';
		$out .= '<div class="image-src3" onclick="changeImage'.$block_num.'d()">';
		$out .= '<img class="img'.$block_num.'" id="img'.$block_num.'-src4" src="wp-content/themes/socialvid/img/icon-play.png"/>';
		$out .= '<h1>'.do_shortcode(htmlspecialchars_decode($title4)).'</h1>';
		$out .= '<p>'.do_shortcode(htmlspecialchars_decode($headline4)).'</p>';
		$out .= '</div>';

		$out .= '</div>';

		$out .= "</div>";

		$out .= "</div>";

		$out .= '<script type="text/javascript" charset="utf-8">';
    	$out .= 'function changeImage'.$block_num.'a() {';
        $out .= 'var elems = document.getElementsByClassName("img'.$block_num.'");';
		$out .= 'for (var i = 0; i < elems.length; i+= 1) {';
    	$out .= 'elems[i].src = "wp-content/themes/socialvid/img/icon-play.png";';
		$out .= '}';
        $out .= 'document.getElementById("img'.$block_num.'-src1").src = "wp-content/themes/socialvid/img/icon-pause.png";';
        $out .= 'document.getElementById("image-main'.$block_num.'").src = "' .htmlspecialchars_decode($module1_image).'";';
    	$out .= '}';
    	$out .= 'function changeImage'.$block_num.'b() {';
        $out .= 'var elems = document.getElementsByClassName("img'.$block_num.'");';
		$out .= 'for (var i = 0; i < elems.length; i+= 1) {';
    	$out .= 'elems[i].src = "wp-content/themes/socialvid/img/icon-play.png";';
		$out .= '}';
        $out .= 'document.getElementById("img'.$block_num.'-src2").src = "wp-content/themes/socialvid/img/icon-pause.png";';
        $out .= 'document.getElementById("image-main'.$block_num.'").src = "' .htmlspecialchars_decode($module2_image).'";';
    	$out .= '}';
    	$out .= 'function changeImage'.$block_num.'c() {';
        $out .= 'var elems = document.getElementsByClassName("img'.$block_num.'");';
		$out .= 'for (var i = 0; i < elems.length; i+= 1) {';
    	$out .= 'elems[i].src = "wp-content/themes/socialvid/img/icon-play.png";';
		$out .= '}';
        $out .= 'document.getElementById("img'.$block_num.'-src3").src = "wp-content/themes/socialvid/img/icon-pause.png";';
        $out .= 'document.getElementById("image-main'.$block_num.'").src = "' .htmlspecialchars_decode($module3_image).'";';
      	$out .= '}';
    	$out .= 'function changeImage'.$block_num.'d() {';
        $out .= 'var elems = document.getElementsByClassName("img'.$block_num.'");';
		$out .= 'for (var i = 0; i < elems.length; i+= 1) {';
    	$out .= 'elems[i].src = "wp-content/themes/socialvid/img/icon-play.png";';
		$out .= '}';
        $out .= 'document.getElementById("img'.$block_num.'-src4").src = "wp-content/themes/socialvid/img/icon-pause.png";';        
        $out .= 'document.getElementById("image-main'.$block_num.'").src = "' .htmlspecialchars_decode($module4_image).'";';
    	$out .= '}';
		$out .= '</script>';
		echo $out;
	}
	
}

?>	