<?php

/** A simple text block **/
class PXS_Image_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Image',
			'size' => 'span12',
		);
		
		//create the block
		parent::__construct('pxs_image_block', $block_options);
	}
	
	function form($instance) {
		
		$defaults = array(
			'slogan' => '',
			'width' => '500',
			'height' => '500',
		);
		
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('slogan') ?>">
				Slogan (Optional)
				<input id="<?php echo $this->get_field_id('slogan') ?>" class="input-full" type="text" value="<?php echo $slogan ?>" name="<?php echo $this->get_field_name('slogan') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('width') ?>">
				Width
				<input id="<?php echo $this->get_field_id('width') ?>" class="input-full" type="text" value="<?php echo $width ?>" name="<?php echo $this->get_field_name('width') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('height') ?>">
				Height
				<input id="<?php echo $this->get_field_id('height') ?>" class="input-full" type="text" value="<?php echo $height ?>" name="<?php echo $this->get_field_name('height') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('alt') ?>">
				Alt
				<input id="<?php echo $this->get_field_id('alt') ?>" class="input-full" type="text" value="<?php echo $alt ?>" name="<?php echo $this->get_field_name('alt') ?>">
			</label>
		</p>
		
		<p class="description">
			<p class="description half">
			<label for="<?php echo $this->get_field_id('feature_img') ?>">
				<?php _e('Upload a feature image', 'pxs'); ?><br/>
				<?php echo aq_field_upload('feature_img', $block_id, $feature_img) ?>
			</label>
			</p>
		</p>
		
		<?php
	}
	
	function block($instance) {
		extract($instance);
		
		$feature_rz = aq_resize($feature_img,$width,$height);
		
		$out = '';
		
		if ($slogan) {$out .= '<h1>'.$slogan.'</h1>';}
		
		$out .= '<img src="'.$feature_rz.'" alt="'.do_shortcode(htmlspecialchars_decode($alt)).'"/>';
		
		echo $out;
	}
	
}

?>