<?php

/* Flexslider Block */

class PXS_FlexSlider_Block extends AQ_Block {

	function __construct() {
		$block_options = array(
			'name'  => 'Features Slider',
			'size'  => 'span12'
		);
		
		parent::__construct('pxs_flexslider_block', $block_options);
		add_action('wp_ajax_aq_block_sliderx_add_new', array($this, 'add_slidex'));
	}

	function form($instance) {
		
		global $op_background;

		$defaults = array(
			'slides' => array(
				1 => array(
					'title'   => 'Slide',
					'upload'  => '',
				)
			),
			'slide_speed'     => 7000,
			'animation_speed' => 600,
			'height'          => '300',
			'animation'       => '',
		);

		$animation_style = array(
			'fade'  => 'Fade',
			'slide' => 'Slide',
		);
		
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		?>
		
		<div class="block-settings-title">
			<h4><?php  _e('1. Fill in the contents for this section', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('slogan') ?>">
				<h4 class="label"><?php  _e('Slogan', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('slogan') ?>" class="input-full" type="text" value="<?php echo $slogan ?>" name="<?php echo $this->get_field_name('slogan') ?>">
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('Feature #1', 'pxs'); ?></h4>
		</div>

		<p class="description">
			<label for="<?php echo $this->get_field_id('title_1') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title_1') ?>" class="input-full" type="text" value="<?php echo $title_1 ?>" name="<?php echo $this->get_field_name('title_1') ?>">
			</label>
			<label for="<?php echo $this->get_field_id('text_1') ?>">
				<h4 class="label"><?php  _e('Content', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('text_1') ?>" class="textarea-full" name="<?php echo $this->get_field_name('text_1') ?>" rows="5"><?php echo $text_1 ?></textarea>
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('Feature #2', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title_2') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title_2') ?>" class="input-full" type="text" value="<?php echo $title_2 ?>" name="<?php echo $this->get_field_name('title_2') ?>">
			</label>
			<label for="<?php echo $this->get_field_id('text_2') ?>">
				<h4 class="label"><?php  _e('Content', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('text_2') ?>" class="textarea-full" name="<?php echo $this->get_field_name('text_2') ?>" rows="5"><?php echo $text_2 ?></textarea>
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('Feature #3', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title_3') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title_3') ?>" class="input-full" type="text" value="<?php echo $title_3 ?>" name="<?php echo $this->get_field_name('title_3') ?>">
			</label>
			<label for="<?php echo $this->get_field_id('text_3') ?>">
				<h4 class="label"><?php  _e('Content', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('text_3') ?>" class="textarea-full" name="<?php echo $this->get_field_name('text_3') ?>" rows="5"><?php echo $text_3 ?></textarea>
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('2. Add Slides', 'pxs'); ?></h4>
		</div>
		
		<div class="description">
			<ul id="sortable-list-<?php echo $block_id ?>" class="aq-sortable-list" rel="<?php echo $block_id ?>">
				<?php
				$slides = is_array($slides) ? $slides : $defaults['slides'];
				$count = 1;
				foreach ($slides as $slide) {	
					$this->slidex($slide, $count);
					$count++;
				}
				?>
			</ul>
			<p></p>
			<a href="#" rel="sliderx" class="aq-sortable-add-new button">Add New</a>
			<p></p>
		</div>
		
		<div class="block-settings-title">
			<h4><?php  _e('3. Section Settings', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('section_name') ?>">
				<h4 class="label"><?php  _e('Section Name eg. Intro', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('section_name') ?>" class="input-full" type="text" value="<?php echo $section_name ?>" name="<?php echo $this->get_field_name('section_name') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('bg') ?>">
				<h4 class="label"><?php  _e('Select a background style', 'pxs'); ?></h4>
				<?php echo aq_field_select('bg', $block_id, $op_background, $bg) ?>
			</label>
		</p>
			
		<p class="description">
			<label for="<?php echo $this->get_field_id('anchor_color') ?>">
				<h4 class="label"><?php  _e('Anchor Color', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('anchor_color') ?>" class="input-color-picker" type="text" value="<?php echo $anchor_color ?>" name="<?php echo $this->get_field_name('anchor_color') ?>">
			</label>
		</p>
		
		<h4 class="label"><?php  _e('Flexslider Settings', 'pxs'); ?></h4>

		<p class="description">
			<label for="<?php echo $this->get_field_id('animation') ?>">
				<h4 class="label"><?php  _e('Animation', 'pxs'); ?></h4>
				<?php echo aq_field_select('animation', $block_id, $animation_style, $animation) ?>
			</label>
		</p>

		<p class="description">
			<label for="<?php echo $this->get_field_id('slide_speed') ?>">
				<h4 class="label"><?php  _e('Slideshow Speed', 'pxs'); ?></h4>
				<?php echo aq_field_input('slide_speed', $block_id, $slide_speed) ?>
			</label>
		</p>

		<p class="description">
			<label for="<?php echo $this->get_field_id('animation_speed') ?>">
				<h4 class="label"><?php  _e('Animation Speed', 'pxs'); ?></h4>
				<?php echo aq_field_input('animation_speed', $block_id, $animation_speed) ?>
			</label>
		</p>
		
	<?php }

	function slidex($slide = array(), $count = 0) {
		
		$defaults = array (
			'title'   => 'New Slide',
			'upload'  => '',
		);

		$slide = wp_parse_args($slide, $defaults); 
		?>

		<li id="<?php echo $this->get_field_id('testimonials') ?>-sortable-item-<?php echo $count ?>" class="sortable-item" rel="<?php echo $count ?>">
			<div class="sortable-head cf">
				<div class="sortable-title">
					<strong><?php echo $slide['title'] ?></strong>
				</div>
				<div class="sortable-handle">
					<a href="#"><?php _e('Open / Close', 'pxs'); ?></a>
				</div>
			</div>
			
			<div class="sortable-body">
				<p class="description">
					<label for="<?php echo $this->get_field_id('slides') ?>-<?php echo $count ?>-upload">
						<?php _e('Upload an iamge', 'pxs'); ?><br/>
						<input type="text" id="<?php echo $this->get_field_id('slides') ?>_<?php echo $count ?>_upload" class="input-full input-upload" value="<?php echo $slide['upload'] ?>" name="<?php echo $this->get_field_name('slides') ?>[<?php echo $count ?>][upload]">
						<a href="#" class="aq_upload_button button" rel="image"><?php _e('Upload', 'pxs'); ?></a>
						<p></p>
					</label>
				</p>
				<p class="description">
					<label for="<?php echo $this->get_field_id('slides') ?>-<?php echo $count ?>-caption">
						<h4 class="label"><?php  _e('Caption', 'pxs'); ?></h4>
						<textarea id="<?php echo $this->get_field_id('slides') ?>-<?php echo $count ?>-caption" class="textarea-full" name="<?php echo $this->get_field_name('slides') ?>[<?php echo $count ?>][caption]" rows="1"><?php echo $slide['caption'] ?></textarea>
					</label>
				</p>
				<p class="description"><a href="#" class="sortable-delete"><?php _e('Delete', 'pxs'); ?></a></p>
			</div>
			
		</li>
	<?php }

	function add_slidex() {
		$nonce = $_POST['security'];	
		if (!wp_verify_nonce($nonce, 'aqpb-settings-page-nonce') ) die('-1');
		
		$count = isset($_POST['count']) ? absint($_POST['count']) : false;
		$this->block_id = isset($_POST['block_id']) ? $_POST['block_id'] : 'aq-block-9999';
		
		$slide = array(
			'title'   => 'New Slide',
			'upload'  => '',
		);
		
		if ($count) {
			$this->slidex($slide, $count);
		} else {
			die(-1);
		}
		
		die();
	}

	function block($instance) {
		extract($instance);
		$rand = rand(1,100);
		if ($section_name == ''){
			$section_name =  'flexslider'. rand();
		}
		?>
		
		<div id="<?php echo $section_name ?>" class="section feature slider <?php echo $bg; ?>" data-colornav="<?php echo $anchor_color ?>">
			
			<div class="content">
			
				<div class="slides aq_span5">
				
					<div id="slider-<?php echo $rand; ?>" class="flexslider loader">
						<ul class="slides">
						<?php
							foreach ($slides as $i=>$slide) {
								$feature_rz = $slide['upload'];
								$out = '';
								$out .= '<li '.$i.'>';
									$out .= '<img src="' . $feature_rz . '" alt="'.$slogan.'" style="max-height: 550px;" />';
									$out .= '<p class="flex-caption">'.$slide['caption'].'</p>';
								$out .= '</li>';
								echo $out;
							}
						?>	
						</ul>
					</div>

				</div>
			
				<div class="info aq_span7">
					
					<h1 class="slogan"><?php echo $slogan ?></h1>
					
					<div class="item">
						<h3><?php echo do_shortcode(htmlspecialchars_decode($title_1)); ?></h3>
						<p><?php echo wpautop(do_shortcode(htmlspecialchars_decode($text_1))); ?></p>
					</div>
					
					<div class="item">
						<h3><?php echo do_shortcode(htmlspecialchars_decode($title_2)); ?></h3>
						<p><?php echo wpautop(do_shortcode(htmlspecialchars_decode($text_2))); ?></p>
					</div>
					
					<div class="item">
						<h3><?php echo do_shortcode(htmlspecialchars_decode($title_3)); ?></h3>
						<p><?php echo wpautop(do_shortcode(htmlspecialchars_decode($text_3))); ?></p>
					</div>
					
				</div>
			
			</div>
		
		</div>
		
		
	<?php 
		$data = array('animation' => $animation, 'slide_speed' => $slide_speed, 'animation_speed' => $animation_speed, 'slide_id' => $rand);
		wp_enqueue_script('flexslider-settings');
		wp_localize_script('flexslider-settings', 'php_data', $data);
	}
	
	function update($new_instance, $old_instance) {
		$new_instance = aq_recursive_sanitize($new_instance);
		return $new_instance;
	}
	
}
