<?php 

/* =FEATURES BLOCK
-------------------------------------------------------------- */

class PXS_Features_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Features',
			'size' => 'span4'
		);
		
		//create the block
		parent::__construct('pxs_features_block', $block_options);
	}
	
	function form($instance) {
		global $heading_size, $icon_anim;
		
		$defaults = array(
			'heading' => 'standard',
			'iconanim' => 'bottomtop'
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>
		<div class="block-settings-title"><i class="icon-align-left"></i><h3><?php  _e('Features', 'pxs'); ?></h3></div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title') ?>">
				<?php _e('Heading', 'pxs'); ?><br/>
				<?php echo aq_field_input('title', $block_id, $title) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('content') ?>">
				<?php _e('Content', 'pxs'); ?><br/>
				<?php echo aq_field_textarea('content', $block_id, $content) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('feature_icon') ?>">
				<?php _e('Icon', 'pxs'); ?><br/>
				<?php echo aq_field_input('feature_icon', $block_id, $feature_icon) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('url') ?>">
				<?php _e('URL (optional)', 'pxs'); ?><br/>
				<?php echo aq_field_input('url', $block_id, $url) ?>
			</label>
		</p>
		
		
		<?php
	}
	
	function block($instance) {
		extract($instance);
		
		if ($section_name == ''){
			$section_name =  'featureblock'. rand();
		}
		$out = '';
		$out .= '<div class="features">';
	    	if ($url) $out .= '<a href="' . $url . '">';
				$out .= '<div class="icon">';
					if ($feature_icon) {
						$out .=  '<i class="' . $feature_icon . '"></i>';
					}
				$out .= '</div>';
				$out .= '<div class="info">';
					$out .= '<h2>' . $title . '</h2>';
					$out .= '<p>' . $content . '</p>';
				$out .= '</div>';
	        if ($url) $out .= '</a>';
	    $out .= '</div>';
	    
	    echo $out;
		
	}
}

?>