<?php

/* Features Basic Block */

class PXS_Features_Basic_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Features',
			'size' => 'span12',
		);
		
		//create the block
		parent::__construct('pxs_features_basic_block', $block_options);
	}
	
	function form($instance) {
	
		global $op_background;
		
		$defaults = array(
			'text' => '',
		);
		
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>
		
		<div class="block-settings-title">
			<h4><?php  _e('1. Fill in the contents for this section', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('slogan') ?>">
				<h4 class="label"><?php  _e('Slogan', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('slogan') ?>" class="input-full" type="text" value="<?php echo $slogan ?>" name="<?php echo $this->get_field_name('slogan') ?>">
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('Feature #1', 'pxs'); ?></h4>
		</div>

		<p class="description">
			<label for="<?php echo $this->get_field_id('title_1') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title_1') ?>" class="input-full" type="text" value="<?php echo $title_1 ?>" name="<?php echo $this->get_field_name('title_1') ?>">
			</label>
			<label for="<?php echo $this->get_field_id('text_1') ?>">
				<h4 class="label"><?php  _e('Content', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('text_1') ?>" class="textarea-full" name="<?php echo $this->get_field_name('text_1') ?>" rows="5"><?php echo $text_1 ?></textarea>
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('Feature #2', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title_2') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title_2') ?>" class="input-full" type="text" value="<?php echo $title_2 ?>" name="<?php echo $this->get_field_name('title_2') ?>">
			</label>
			<label for="<?php echo $this->get_field_id('text_2') ?>">
				<h4 class="label"><?php  _e('Content', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('text_2') ?>" class="textarea-full" name="<?php echo $this->get_field_name('text_2') ?>" rows="5"><?php echo $text_2 ?></textarea>
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('Feature #3', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title_3') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title_3') ?>" class="input-full" type="text" value="<?php echo $title_3 ?>" name="<?php echo $this->get_field_name('title_3') ?>">
			</label>
			<label for="<?php echo $this->get_field_id('text_3') ?>">
				<h4 class="label"><?php  _e('Content', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('text_3') ?>" class="textarea-full" name="<?php echo $this->get_field_name('text_3') ?>" rows="5"><?php echo $text_3 ?></textarea>
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('2. Upload Images', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<p class="description">
			<label for="<?php echo $this->get_field_id('feature_img') ?>">
				<?php _e('Upload a feature image', 'pxs'); ?><br/>
				<?php echo aq_field_upload('feature_img', $block_id, $feature_img) ?>
			</label>
			</p>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('3. Section Settings', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('section_name') ?>">
				<h4 class="label"><?php  _e('Section Name eg. Intro', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('section_name') ?>" class="input-full" type="text" value="<?php echo $section_name ?>" name="<?php echo $this->get_field_name('section_name') ?>">
			</label>
		</p>
				
		<p class="description">
			<label for="<?php echo $this->get_field_id('bg') ?>">
				<h4 class="label"><?php  _e('Select a background style', 'pxs'); ?></h4>
				<?php echo aq_field_select('bg', $block_id, $op_background, $bg) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('anchor_color') ?>">
				<h4 class="label"><?php  _e('Anchor Color', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('anchor_color') ?>" class="input-color-picker" type="text" value="<?php echo $anchor_color ?>" name="<?php echo $this->get_field_name('anchor_color') ?>">
			</label>
		</p>
		
		<?php
	}
	
	function block($instance) {
		extract($instance);
		
		//$feature_rz = aq_resize($feature_img,'',550);
		if ($section_name == ''){
			$section_name =  'basic'. rand();
		}
		
		?>
		
		<div id="<?php echo $section_name ?>" class="section feature basic <?php echo $bg; ?>" data-colornav="<?php echo $anchor_color ?>">
			
			<div class="content">
			
				<div class="image aq_span5">
					<img class="feature" src="<?php echo $feature_img; ?>" alt="<?php do_shortcode(htmlspecialchars_decode($title))?>" style="max-height: 550px;" />
				</div>
			
				<div class="info aq_span7">
					
					<h1 class="slogan"><?php echo $slogan ?></h1>
					
					<div class="item">
						<h3><?php echo do_shortcode(htmlspecialchars_decode($title_1)); ?></h3>
						<p><?php echo wpautop(do_shortcode(htmlspecialchars_decode($text_1))); ?></p>
					</div>
					
					<div class="item">
						<h3><?php echo do_shortcode(htmlspecialchars_decode($title_2)); ?></h3>
						<p><?php echo wpautop(do_shortcode(htmlspecialchars_decode($text_2))); ?></p>
					</div>
					
					<div class="item">
						<h3><?php echo do_shortcode(htmlspecialchars_decode($title_3)); ?></h3>
						<p><?php echo wpautop(do_shortcode(htmlspecialchars_decode($text_3))); ?></p>
					</div>
					
				</div>
			
			</div>
		
		</div>
		
		<?php
	
	}
}

?>