<?php

/* Downloads Block */

class PXS_Downloads_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Downloads',
			'size' => 'span12',
		);
		
		//create the block
		parent::__construct('pxs_downloads_block', $block_options);
	}
	
	function form($instance) {
	
		global $op_background;
		global $op_break_layout_new;

		
		$defaults = array(
			'text' => '',
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>

		<!-- Added Code -->


		<div class="block-settings-title">
			<h4><?php  _e('Parallax Background', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('parallax_layout') ?>">
				<h4 class="label"><?php  _e('Select a layout', 'pxs'); ?></h4>
				<?php echo aq_field_select('parallax_layout', $block_id, $op_break_layout_new, $parallax_layout) ?>
			</label>
		</p>

		<!-- Added Code -->
		
		<div class="block-settings-title">
			<h4><?php  _e('1. Fill in the contents for this section', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('title') ?>">
				<h4 class="label"><?php  _e('Title', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('title') ?>" class="input-full" type="text" value="<?php echo $title ?>" name="<?php echo $this->get_field_name('title') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('text') ?>">
				<h4 class="label"><?php  _e('Content', 'pxs'); ?></h4>
				<textarea id="<?php echo $this->get_field_id('text') ?>" class="textarea-full" name="<?php echo $this->get_field_name('text') ?>" rows="5"><?php echo $text ?></textarea>
			</label>
		</p>

		<p class="description">
			<label for="<?php echo $this->get_field_id('downloads') ?>">
				<h4 class="label"><?php  _e('Total Downloads', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('downloads') ?>" class="input-full" type="text" value="<?php echo $downloads ?>" name="<?php echo $this->get_field_name('downloads') ?>">
			</label>
		</p>
		
		<div class="block-settings-title">
			<h4><?php  _e('2. Section Settings', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('section_name') ?>">
				<h4 class="label"><?php  _e('Section Name eg. Intro', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('section_name') ?>" class="input-full" type="text" value="<?php echo $section_name ?>" name="<?php echo $this->get_field_name('section_name') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('bg') ?>">
				<h4 class="label"><?php  _e('Select a background style', 'pxs'); ?></h4>
				<?php echo aq_field_select('bg', $block_id, $op_background, $bg) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('anchor_color') ?>">
				<h4 class="label"><?php  _e('Anchor Color', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('anchor_color') ?>" class="input-color-picker" type="text" value="<?php echo $anchor_color ?>" name="<?php echo $this->get_field_name('anchor_color') ?>">
			</label>
		</p>
		
		<?php
	}
	
	function block($instance) {
		extract($instance);
		
		if ($section_name == ''){
			$section_name =  'downloads'. rand();
		}
		$out = '';
		
		$out .= '<div id="'.$section_name.'" class="section downloads '.$bg.'" data-colornav="'.$anchor_color.'" style="padding-top:25px;padding-bottom:25px;" data-speed="10" data-type="background">';

		if ($parallax_layout == 'parone') {
			$out .= '<div class="parallaxmodule3 parallax parallax-1"><div class="container" data-speed="10" data-type="background">';
		}

		if ($parallax_layout == 'partwo') {
			$out .= '<div class="parallaxmodule3 parallax parallax-2"><div class="container" data-speed="10" data-type="background">';
		}

		if ($parallax_layout == 'parthree') {
			$out .= '<div class="parallaxmodule3 parallax parallax-3"><div class="container" data-speed="10" data-type="background">';
		}

		if ($parallax_layout == 'parfour') {
			$out .= '<div class="parallaxmodule3 parallax parallax-4"><div class="container" data-speed="10" data-type="background">';
		}

		if ($parallax_layout == 'parfive') {
			$out .= '<div class="parallaxmodule3 parallax parallax-5"><div class="container" data-speed="10" data-type="background">';
		}
		
		$out .= '<div class="content">';
		
		$out .= '<div class="info">';
			$out .= '<h1>'.do_shortcode(htmlspecialchars_decode($title)).'</h1>';
			$out .= '<p>'.do_shortcode(htmlspecialchars_decode($text)).'</p>';
			
			$out .= '<div class="dl">';
			
			$strlen = strlen( $downloads ) - 1;
			for( $i = 0; $i <= $strlen; $i++ ) {
			    $char = substr( $downloads, $i, 1 );
			    $out .= '<span>'.$char.'</span>';
			}
			$out .= '</div>';
			
			$out .= '<h6>downloads</h6>';
			
		$out .= "</div>";
		
		// $out .= '<div class="icon left">';
		// $out .= '<i class="icon-download-alt"></i>';
		// $out .= '</div>';
		
		// $out .= '<div class="icon right">';
		// $out .= '<i class="icon-download-alt"></i>';
		// $out .= '</div>';
		
		$out .= "</div>";

		$out .= '</div></div>';
			
		$out .= "</div>";
		
		echo $out;
	}
	
}

?>