<?php

/* Blog Post Block */

class PXS_Blogpost_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Blog Post',
			'size' => 'span12',
		);
		
		//create the block
		parent::__construct('pxs_blogpost_block', $block_options);
	}
	
	function form($instance) {
	
		global $op_background;
		
		$defaults = array(
			'text' => '',
		);
		
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>
		
		<div class="block-settings-title">
			<h4><?php  _e('1. Section Settings', 'pxs'); ?></h4>
		</div>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('section_name') ?>">
				<h4 class="label"><?php  _e('Section Name eg. Intro', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('section_name') ?>" class="input-full" type="text" value="<?php echo $section_name ?>" name="<?php echo $this->get_field_name('section_name') ?>">
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('bg') ?>">
				<h4 class="label"><?php  _e('Select a background style', 'pxs'); ?></h4>
				<?php echo aq_field_select('bg', $block_id, $op_background, $bg) ?>
			</label>
		</p>
		
		<p class="description">
			<label for="<?php echo $this->get_field_id('anchor_color') ?>">
				<h4 class="label"><?php  _e('Anchor Color', 'pxs'); ?></h4>
				<input id="<?php echo $this->get_field_id('anchor_color') ?>" class="input-color-picker" type="text" value="<?php echo $anchor_color ?>" name="<?php echo $this->get_field_name('anchor_color') ?>">
			</label>
		</p>
		
		<?php
	}
	
	function block($instance) {
		extract($instance);
		
		if ($section_name == ''){
			$section_name =  'blogpost'. rand();
		}
		$args = array( 'post_type' => 'post', 'posts_per_page' => 1, 'post__not_in' => get_option( 'sticky_posts' ) );
		$query = new WP_Query( $args );
		
		$out = '';
		
		$out .= '<div id="'.$section_name.'" class="section blogpost '.$bg.'" data-colornav="'.$anchor_color.'">';
		$out .= '<div class="content">';
		
			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
					$query->the_post();
					if (has_post_thumbnail()){
						$out .= '<div class="image aq_span4">';
					}else{
						$out .= '<div class="image aq_span4 blogimg">';
					}
					$out .= '<i class="icon-align-left"></i>';
					$out .= get_the_post_thumbnail();
					$out .= '</div>';
					
					$out .= '<div class="info aq_span8">';
					$out .= '<a href="'.get_post_permalink().'"><h2>'. get_the_title() .'</a></h2>';
					$out .= '<p>' . get_the_excerpt() . '</p>';
					$out .= '<div class="meta">posted by <span>'.get_the_author_meta('display_name').'</span> on <span>'.get_post_time('d M Y', true).'</span> with <span>'.get_comments_number().'</span> comments</div>';
					$out .= '</div>';
					
				}
			}

		
		$out .= '</div>';
			
		$out .= '</div>';

		echo $out;
	
	}
}

?>