(function($) {
    "use strict";
    
    /* Get php values from pxs-map-block */
    var lat = php_data.lat;
    var lng = php_data.lng;
    var zoomlevel = php_data.zoom;
    var minfo = php_data.info;
    var mapid = php_data.mapid;
    
    $(function initialize() {

    	var myLatlng = new google.maps.LatLng(parseFloat(lat), parseFloat(lng));
    	
    	var mapOptions = {
		    zoom: parseInt(zoomlevel),
		    center: myLatlng,
		    mapTypeId: google.maps.MapTypeId.ROADMAP
		  }
		  var map = new google.maps.Map(document.getElementById('map-canvas-' + mapid), mapOptions);
		  
		  var contentString = php_data.info;
		  
		  var infowindow = new google.maps.InfoWindow({
			 content: contentString
		  });
		
		  var marker = new google.maps.Marker({
		      position: myLatlng,
		      map: map
		  });
		  google.maps.event.addListener(marker, 'click', function() {
		    infowindow.open(map,marker);
		  });
	  });
 
}(jQuery));
