<?php
/**
 * _s Theme Customizer
 *
 * @package _s
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
 
function pxs_customize_register( $wp_customize ) {

	$font_face = array(
		'Arial, "Helvetica Neue", Helvetica, sans-serif'     => 'Arial, "Helvetica Neue", Helvetica, sans-serif',
		'Verdana, Geneva, Tahoma, sans-serif'   => 'Verdana, Geneva, Tahoma, sans-serif',
		'Trebuchet, Tahoma, Arial, sans-serif' => 'Trebuchet, Tahoma, Arial, sans-serif',
		'Georgia, Times, "Times New Roman", serif'   => 'Georgia, Times, "Times New Roman", serif',
		'Times, "Times New Roman", Georgia, serif'     => 'Times, "Times New Roman", Georgia, serif',
		'Tahoma, Verdana, Geneva'    => 'Tahoma, Verdana, Geneva',
		'Palatino, "Palatino Linotype", Georgia, Times, "Times New Roman", serif'  => 'Palatino, "Palatino Linotype", Georgia, Times, "Times New Roman", serif',
		'Helvetica, "Helvetica Neue", Arial, sans-serif' => 'Helvetica, "Helvetica Neue", Arial, sans-serif'
	);
	
	$font_size = array('10px' => '10px','11px' => '11px','12px' => '12px','13px' => '13px','14px' => '14px','15px' => '15px','16px' => '16px','17px' => '17px','18px' => '18px','19px' => '19px','20px' => '20px','21px' => '21px','22px' => '22px','23px' => '23px','24px' => '24px','25px' => '25px','26px' => '26px','27px' => '27px','28px' => '28px','29px' => '29px','30px' => '30px','31px' => '31px','32px' => '32px','33px' => '33px','34px' => '34px','35px' => '35px','36px' => '36px','37px' => '37px','38px' => '38px','39px' => '39px','40px' => '40px','41px' => '41px','42px' => '42px','43px' => '43px','44px' => '44px','45px' => '45px','46px' => '46px','47px' => '47px','48px' => '48px','49px' => '49px','50px' => '50px'
		);
	
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
	
	$wp_customize->add_section( 'typography', array(
            'title'    => __( 'Typography','pxs' ),
            'priority' => 21,
    ) );
    
    $wp_customize->add_setting(
	    'font_body',
	    array(
	        'default' => 'Arial, "Helvetica Neue", Helvetica, sans-serif',
	    )
	);
	 
	$wp_customize->add_control(
	    'font_body',
	    array(
	        'type' => 'select',
	        'label' => 'Font: Body',
	        'section' => 'typography',
	        'choices' => $font_face,
	    )
	);
	
	$wp_customize->add_setting(
	    'font_heading',
	    array(
	        'default' => 'Arial, "Helvetica Neue", Helvetica, sans-serif',
	    )
	);
	 
	$wp_customize->add_control(
	    'font_heading',
	    array(
	        'type' => 'select',
	        'label' => 'Font: Heading',
	        'section' => 'typography',
	        'choices' => $font_face,
	    )
	);
	
	$wp_customize->add_setting(
	    'font_widget_heading',
	    array(
	        'default' => 'Arial, "Helvetica Neue", Helvetica, sans-serif',
	    )
	);
	 
	$wp_customize->add_control(
	    'font_widget_heading',
	    array(
	        'type' => 'select',
	        'label' => 'Font: Widget Heading',
	        'section' => 'typography',
	        'choices' => $font_face,
	    )
	);
	
	$wp_customize->add_setting(
	    'font_size_paragraph',
	    array(
	        'default' => '14px',
	    )
	);
	 
	$wp_customize->add_control(
	    'font_size_paragraph',
	    array(
	        'type' => 'select',
	        'label' => 'Font Size: Paragraph',
	        'section' => 'typography',
	        'choices' => $font_size,
	    )
	);
	
	$wp_customize->add_setting(
	    'font_size_heading_h1',
	    array(
	        'default' => '32px',
	    )
	);
	 
	$wp_customize->add_control(
	    'font_size_heading_h1',
	    array(
	        'type' => 'select',
	        'label' => 'Font Size: H1',
	        'section' => 'typography',
	        'choices' => $font_size,
	    )
	);
	
	$wp_customize->add_setting(
	    'font_size_heading_h2',
	    array(
	        'default' => '24px',
	    )
	);
	 
	$wp_customize->add_control(
	    'font_size_heading_h2',
	    array(
	        'type' => 'select',
	        'label' => 'Font Size: H2',
	        'section' => 'typography',
	        'choices' => $font_size,
	    )
	);
	
	$wp_customize->add_setting(
	    'font_size_heading_h3',
	    array(
	        'default' => '18px',
	    )
	);
	 
	$wp_customize->add_control(
	    'font_size_heading_h3',
	    array(
	        'type' => 'select',
	        'label' => 'Font Size: H3',
	        'section' => 'typography',
	        'choices' => $font_size,
	    )
	);
	
	$wp_customize->add_setting(
	    'font_size_heading_h4',
	    array(
	        'default' => '16px',
	    )
	);
	 
	$wp_customize->add_control(
	    'font_size_heading_h4',
	    array(
	        'type' => 'select',
	        'label' => 'Font Size: H4',
	        'section' => 'typography',
	        'choices' => $font_size,
	    )
	);
	
	$wp_customize->add_setting(
	    'font_size_heading_h5',
	    array(
	        'default' => '13px',
	    )
	);
	 
	$wp_customize->add_control(
	    'font_size_heading_h5',
	    array(
	        'type' => 'select',
	        'label' => 'Font Size: H5',
	        'section' => 'typography',
	        'choices' => $font_size,
	    )
	);
	
	$wp_customize->add_setting(
	    'font_size_heading_h6',
	    array(
	        'default' => '12px',
	    )
	);
	 
	$wp_customize->add_control(
	    'font_size_heading_h6',
	    array(
	        'type' => 'select',
	        'label' => 'Font Size: H6',
	        'section' => 'typography',
	        'choices' => $font_size,
	    )
	);
	
	$wp_customize->add_setting(
	    'font_color_heading',
	    array(
	        'default' => '#ffffff',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
	 
	$wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'font_color_heading',
	        array(
	            'label' => 'Heading Color',
	            'section' => 'colors',
	            'settings' => 'font_color_heading'
	        )
	    )
	);
	
	$wp_customize->add_setting(
	    'font_color_paragraph',
	    array(
	        'default' => '#c2bdb4',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
	 
	$wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'font_color_paragraph',
	        array(
	            'label' => 'Paragraph Color',
	            'section' => 'colors',
	            'settings' => 'font_color_paragraph'
	        )
	    )
	);
	
	$wp_customize->add_setting(
	    'bgcolor_post_meta',
	    array(
	        'default' => '#f55d0a',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
	 
	$wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'bgcolor_post_meta',
	        array(
	            'label' => 'Post Meta Background Color',
	            'section' => 'colors',
	            'settings' => 'bgcolor_post_meta'
	        )
	    )
	);
	
	$wp_customize->add_setting(
	    'bdrcolor_post_meta',
	    array(
	        'default' => '#b94201',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
	 
	$wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'bdrcolor_post_meta',
	        array(
	            'label' => 'Post Meta Border Color',
	            'section' => 'colors',
	            'settings' => 'bdrcolor_post_meta'
	        )
	    )
	);
	
	$wp_customize->add_setting(
	    'bgcolor_post_img',
	    array(
	        'default' => '#333',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
	 
	$wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'bgcolor_post_img',
	        array(
	            'label' => 'Post Image Background Color',
	            'section' => 'colors',
	            'settings' => 'bgcolor_post_img'
	        )
	    )
	);
	
	$wp_customize->add_setting(
	    'bdrcolor_post_img',
	    array(
	        'default' => '#9c968b',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
	 
	$wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'bdrcolor_post_img',
	        array(
	            'label' => 'Post Image Border Color',
	            'section' => 'colors',
	            'settings' => 'bdrcolor_post_img'
	        )
	    )
	);
	
	$wp_customize->add_setting(
	    'bdrcolor_widget_title',
	    array(
	        'default' => '#f55d0a',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
	 
	$wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'bdrcolor_widget_title',
	        array(
	            'label' => 'Widget Title Border Color',
	            'section' => 'colors',
	            'settings' => 'bdrcolor_widget_title'
	        )
	    )
	);
	
	$wp_customize->add_setting(
	    'bdrcolor_widget_item',
	    array(
	        'default' => '#555',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
	 
	$wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'bdrcolor_widget_item',
	        array(
	            'label' => 'Widget Item Border Color',
	            'section' => 'colors',
	            'settings' => 'bdrcolor_widget_item'
	        )
	    )
	);
	
	$wp_customize->add_setting(
	    'bgcolor_icon',
	    array(
	        'default' => '#f55d0a',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
	 
	$wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'bgcolor_icon',
	        array(
	            'label' => 'Icon Background Color',
	            'section' => 'colors',
	            'settings' => 'bgcolor_icon'
	        )
	    )
	);
	
	$wp_customize->add_setting(
	    'bdrcolor_icon_left',
	    array(
	        'default' => '#983a07',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
	 
	$wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'bdrcolor_icon_left',
	        array(
	            'label' => 'Icon Left Border Color',
	            'section' => 'colors',
	            'settings' => 'bdrcolor_icon_left'
	        )
	    )
	);
	
	$wp_customize->add_setting(
	    'bdrcolor_icon_right',
	    array(
	        'default' => '#983a07',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
	 
	$wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'bdrcolor_icon_right',
	        array(
	            'label' => 'Icon Right Border Color',
	            'section' => 'colors',
	            'settings' => 'bdrcolor_icon_right'
	        )
	    )
	);
	
	$wp_customize->add_setting(
	    'bdrcolor_icon_bottom',
	    array(
	        'default' => '#b94201',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
	 
	$wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'bdrcolor_icon_bottom',
	        array(
	            'label' => 'Icon Bottom Border Color',
	            'section' => 'colors',
	            'settings' => 'bdrcolor_icon_bottom'
	        )
	    )
	);
	
	$wp_customize->add_setting(
	    'bgcolor_button',
	    array(
	        'default' => '#FF0438',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
	 
	$wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'bgcolor_button',
	        array(
	            'label' => 'Button Background Color',
	            'section' => 'colors',
	            'settings' => 'bgcolor_button'
	        )
	    )
	);
	
	$wp_customize->add_setting(
	    'bdrcolor_button',
	    array(
	        'default' => '#C00028',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
	 
	$wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'bdrcolor_button',
	        array(
	            'label' => 'Button Border Color',
	            'section' => 'colors',
	            'settings' => 'bdrcolor_button'
	        )
	    )
	);
	
	$wp_customize->add_setting(
	    'bdrcolor_breadcrumb',
	    array(
	        'default' => '#f55d0a',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
	 
	$wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'bdrcolor_breadcrumb',
	        array(
	            'label' => 'Breadcrumb Border Color',
	            'section' => 'colors',
	            'settings' => 'bdrcolor_breadcrumb'
	        )
	    )
	);
	
	$wp_customize->add_setting(
	    'breadcrumb_link_color',
	    array(
	        'default' => '#d7d3cc',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
	 
	$wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'breadcrumb_link_color',
	        array(
	            'label' => 'Breadcrumb Link Color',
	            'section' => 'colors',
	            'settings' => 'breadcrumb_link_color'
	        )
	    )
	);
	
	$wp_customize->add_setting(
	    'breadcrumb_span_color',
	    array(
	        'default' => '#a6a29c',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
	 
	$wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'breadcrumb_span_color',
	        array(
	            'label' => 'Breadcrumb Span Color',
	            'section' => 'colors',
	            'settings' => 'breadcrumb_span_color'
	        )
	    )
	);
	
	$wp_customize->add_setting(
	    'breadcrumb_current_color',
	    array(
	        'default' => '#f55d0a',
	        'sanitize_callback' => 'sanitize_hex_color',
	    )
	);
	 
	$wp_customize->add_control(
	    new WP_Customize_Color_Control(
	        $wp_customize,
	        'breadcrumb_current_color',
	        array(
	            'label' => 'Breadcrumb Current Color',
	            'section' => 'colors',
	            'settings' => 'breadcrumb_current_color'
	        )
	    )
	);
	
}
add_action( 'customize_register', 'pxs_customize_register' );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
 
add_action( 'wp_footer', 'customize_preview', 21);

function customize_preview() {
    ?>
    
    <?php
}  // End function example_customize_preview()

function my_styles_method() {
	wp_enqueue_style(
		'custom-style',
		get_template_directory_uri() . '/css/custom_script.css'
	);
	
        $font_body = get_theme_mod( 'font_body' );
        $font_heading = get_theme_mod( 'font_heading' );
        $font_widget_heading = get_theme_mod( 'font_widget_heading' );
        $font_size_paragraph = get_theme_mod( 'font_size_paragraph' );
        $font_size_heading_h1 = get_theme_mod( 'font_size_heading_h1' );
        $font_size_heading_h2 = get_theme_mod( 'font_size_heading_h2' );
        $font_size_heading_h3 = get_theme_mod( 'font_size_heading_h3' );
        $font_size_heading_h4 = get_theme_mod( 'font_size_heading_h4' );
        $font_size_heading_h5 = get_theme_mod( 'font_size_heading_h5' );
        $font_size_heading_h6 = get_theme_mod( 'font_size_heading_h6' );
        $font_color_heading = get_theme_mod( 'font_color_heading' );
        $font_color_paragraph = get_theme_mod( 'font_color_paragraph' );
        $bgcolor_post_meta = get_theme_mod( 'bgcolor_post_meta' );
        $bdrcolor_post_meta = get_theme_mod( 'bdrcolor_post_meta' );
        $bgcolor_post_img = get_theme_mod( 'bgcolor_post_img' );
        $bdrcolor_post_img = get_theme_mod( 'bdrcolor_post_img' );
        $bdrcolor_widget_title = get_theme_mod( 'bdrcolor_widget_title' );
        $bdrcolor_widget_item = get_theme_mod( 'bdrcolor_widget_item' );
        $bgcolor_icon = get_theme_mod( 'bgcolor_icon' );
        $bdrcolor_icon_left = get_theme_mod( 'bdrcolor_icon_left' );
        $bdrcolor_icon_right = get_theme_mod( 'bdrcolor_icon_right' );
        $bdrcolor_icon_bottom = get_theme_mod( 'bdrcolor_icon_bottom' );
        $bgcolor_button = get_theme_mod( 'bgcolor_button' );
        $bdrcolor_button = get_theme_mod( 'bdrcolor_button' );
        $bdrcolor_breadcrumb = get_theme_mod( 'bdrcolor_breadcrumb' );
        $breadcrumb_link_color = get_theme_mod( 'breadcrumb_link_color' );
        $breadcrumb_span_color = get_theme_mod( 'breadcrumb_span_color' );
        $breadcrumb_current_color = get_theme_mod( 'breadcrumb_current_color' );
        
		if ($bgcolor_button == "") {$bgcolor_button="#FF0438";}
		if ($bdrcolor_button == "") {$bdrcolor_button="#C00028";}
		
        $custom_css = "
                body {
                    font-family: {$font_body};
                }
                
                h1,h2,h3,h4,h5,h6 {
                    font-family: {$font_heading};
                }
                
                h1,h2,h3,h4,h5,h6, .wrap .content .entry-title a, .page-header .entry-title, .page-header.blog .entry-title, .introduction .content h1, .features-basic .slogan.std h1, .site-footer .site-info .site-title a {
                    color: {$font_color_heading};
                }
                
                p, .widget ul li a, .widget ul li, .introduction .content h3 {
                	color: {$font_color_paragraph};
                }
                
                .widget h1 {
                	font-family: {$font_widget_heading};
                	border-left : 2px dashed {$bdrcolor_widget_title};
                }
                
                p, .wrap .content .entry-content p {
                	font-size: {$font_size_paragraph};
                }
                
                h1, .wrap .content .entry-title a, .introduction .content h1 {
                    font-size: {$font_size_heading_h1};
                }
                
                h2 {
                    font-size: {$font_size_heading_h2};
                }
                
                h3 {
                    font-size: {$font_size_heading_h3};
                }
                
                h4 {
                    font-size: {$font_size_heading_h4};
                }
                
                h5 {
                    font-size: {$font_size_heading_h5};
                }
                
                h6 {
                    font-size: {$font_size_heading_h6};
                }
                
                .wrap .entry-meta {
                	background: {$bgcolor_post_meta};
                	border-bottom: 3px solid {$bdrcolor_post_meta};
                }
                .wrap .content .entry-thumbnail img{
					background: {$bgcolor_post_img};
					border-bottom: 3px solid {$bdrcolor_post_img};
				}
                .widget ul li {
                	border-bottom: 1px dashed {$bdrcolor_widget_item};
                }
                
                .features-icon .item .icon i, .testimonials .content .image i,.blogpost .content .image i{
                	background: {$bgcolor_icon};
                	border-left: 2px solid {$bdrcolor_icon_left};
                	border-right: 2px solid {$bdrcolor_icon_right};
                	border-bottom: 2px solid {$bdrcolor_icon_bottom};
                }

				.feature.perspective .info .item i,.feature.landscape .info .item i,.steps .item i{
					background: {$bgcolor_icon};
					border-bottom: 2px solid {$bdrcolor_icon_bottom};
				}
				.features .icon{
					background: {$bgcolor_icon};
					border: 2px solid {$bdrcolor_icon_bottom};
				}
                .features:hover .icon {
					background: {$bgcolor_icon};
					opacity: 0.9;
					-webkit-animation: pulse 2s infinite;
				}
				.feature.perspective .item:hover{
					border-bottom: 2px dashed {$bdrcolor_icon_bottom};
				}
                .folio-button,input[type='submit'],input[type='submit']:hover,.pricing-table .cta a,.aq_block_tabs ul.aq-nav li.ui-tabs-active a,.callout .content a, .newsletter .content a, .introduction .content a, .site-branding .site-title a, .content .customlinks a,.downloads .content .info .dl span,.subscription .ptable ul,.aq_block_toggle h2.tab-head, .aq_block_accordion h2.tab-head{
                	background: {$bgcolor_button} !important;
                	border-bottom: 3px solid {$bdrcolor_button} !important;
                }
                .folio-button a, .folio-button,a:visited{
					color:#fff;
					padding: 10px 14px;
					border-radius: 4px;
				}
                .page-header .breadcrumbs, .page-header.blog .tagline {
                	border-left: 2px dashed {$bdrcolor_breadcrumb};
                	color: {$breadcrumb_span_color};
                }
                
                .team:hover .social a,.team .social a:hover,.team .profile h5, .pricing-table h2,.main-navigation li:hover > a,.page-header .breadcrumbs span.current {
                	color: {$breadcrumb_current_color};
                }
				
                .sf-menu ul li {
					border-left: 2px dashed {$breadcrumb_current_color};
				}
                .page-header .breadcrumbs a {
                	color: {$breadcrumb_link_color};
                }
				
                .aq_block_tabs ul.aq-nav li.ui-tabs-active a {
					color:#fff;
				}
				
				.aq_block_tabs ul.aq-nav li a {
					color: #333;
				}
				.aq_block_accordion h2.tab-head {
					color:#fff;
				}
                
				.introduction-video iframe {
					border: 1px solid $font_color_heading;
				}
                ";
                
        wp_add_inline_style( 'custom-style', $custom_css );
}
add_action( 'wp_enqueue_scripts', 'my_styles_method' );