<?php

/**

 * The template for Header

 *

 */


global $smof_data;

?><!DOCTYPE html>

<html <?php language_attributes(); ?> id="html">

<head>

<meta http-equiv="X-UA-Compatible" content="IE=Edge,chrome=1" />

<meta charset="<?php bloginfo( 'charset' ); ?>">

<meta name="viewport" content="width=device-width">

<title><?php wp_title( '|', true, 'right' ); ?></title>

<link rel="profile" href="http://gmpg.org/xfn/11">

<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">



<!-- Default Favicon -->

<?php if ($smof_data['favicon']) : ?>

<link rel="shortcut icon" href="<?php echo $smof_data['../instaportfoliopro/favicon']; ?>" />

<?php endif; ?>



<!-- Favicon For iPhone -->

<?php if($smof_data['iphone_icon']): ?>

<link rel="apple-touch-icon-precomposed" href="<?php echo $smof_data['../instaportfoliopro/iphone_icon']; ?>">

<?php endif; ?>



<!-- Favicon For iPhone 4 Retina display -->

<?php if($smof_data['iphone_icon_retina']): ?>

<link rel="apple-touch-icon-precomposed" sizes="114x114" href="<?php echo $smof_data['../instaportfoliopro/iphone_icon_retina']; ?>">

<?php endif; ?>



<!-- Favicon For iPad -->

<?php if($smof_data['ipad_icon']): ?>

<link rel="apple-touch-icon-precomposed" sizes="72x72" href="<?php echo $smof_data['../instaportfoliopro/ipad_icon']; ?>">

<?php endif; ?>



<!-- Favicon For iPad Retina display -->

<?php if($smof_data['ipad_icon_retina']): ?>

<link rel="apple-touch-icon-precomposed" sizes="144x144" href="<?php echo $smof_data['../instaportfoliopro/ipad_icon_retina']; ?>">

<?php endif; ?>



<!-- Favicon For iPad Retina display -->

<?php if($smof_data['ipad_icon_retina']): ?>

<link rel="apple-touch-icon-precomposed" sizes="144x144" href="<?php echo $smof_data['../instaportfoliopro/ipad_icon_retina']; ?>">

<?php endif; ?>



<?php wp_head(); ?>



<link rel="stylesheet" type="text/css" href="http://fonts.googleapis.com/css?family=Open+Sans">

<?php
function isMobile() {
    return preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"]);
}

if(!isMobile()){

?>
<style>

/*Main Parallax*/

div.parallaxmodule.parallax,
div.parallaxmodule2.parallax,
div.parallaxmodule3.parallax {
  position: inherit !important;
  background-position: 50% 50%;
  background-repeat: no-repeat;
  background-attachment: fixed;
  -webkit-background-size: cover;
  -moz-background-size: cover;
  -o-background-size: cover;
  background-size: cover;
  -moz-box-shadow:    inset 0 0 10px #000000;
  -webkit-box-shadow: inset 0 0 10px #000000;
  box-shadow:         inset 0 0 10px #000000;
}

</style>

<?php

} else {
?>

<style>
div.parallaxmodule.parallax,
div.parallaxmodule2.parallax,
div.parallaxmodule3.parallax {
  position: inherit !important;
  background-position: 50% 50%;
  background-repeat: no-repeat;
  background-attachment: initial;
  -webkit-background-size: cover;
  -moz-background-size: cover;
  -o-background-size: cover;
  background-size: cover;
  -moz-box-shadow:    inset 0 0 10px #000000;
  -webkit-box-shadow: inset 0 0 10px #000000;
  box-shadow:         inset 0 0 10px #000000;
}
</style>

<?php
}

?>

<style>
div.parallaxmodule:last-child {
  margin-bottom: 0;
}
div.parallaxmodule h2 {
  margin-bottom: 40px;
  font-family: "Roboto Slab", serif;
  font-size: 30px;
}
div.parallaxmodule p {
  margin-bottom: 40px;
  font-size: 16px;
  font-weight: 300;
}
div.parallaxmodule p:last-child {
  margin-bottom: 0;
}
div.parallaxmodule.content {
  padding: 40px 0;
}

div.parallaxmodule.parallax h1 {
  color: rgba(255, 255, 255, 0.8);
  font-size: 48px;
  font-weight: 700;
  text-align: center;
  text-transform: uppercase;
  text-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
}

div.parallaxmodule2.parallax h1,
div.parallaxmodule3.parallax h1 {
  color: rgba(255, 255, 255, 0.8);
  font-size: 20px;
  font-weight: 700;
  text-align: center;
  text-transform: uppercase;
  text-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
}

div.parallaxmodule.parallax {
  height: 250px;
}
div.parallaxmodule2.parallax {
  height: 600px;
}
div.parallaxmodule3.parallax {
  height: 400px;
}

div.parallaxmodule.parallax-1,
div.parallaxmodule2.parallax-1,
div.parallaxmodule3.parallax-1 {
  background-image: url("<?php echo get_template_directory_uri(); ?>/img/1.jpg");
}
div.parallaxmodule.parallax-2,
div.parallaxmodule2.parallax-2,
div.parallaxmodule3.parallax-2 {
  background-image: url("<?php echo get_template_directory_uri(); ?>/img/2.jpg");
}
div.parallaxmodule.parallax-3,
div.parallaxmodule2.parallax-3,
div.parallaxmodule3.parallax-3 {
  background-image: url("<?php echo get_template_directory_uri(); ?>/img/3.jpg");
}
div.parallaxmodule.parallax-4,
div.parallaxmodule2.parallax-4,
div.parallaxmodule3.parallax-4 {
  background-image: url("<?php echo get_template_directory_uri(); ?>/img/4.jpg");
}
div.parallaxmodule.parallax-5,
div.parallaxmodule2.parallax-5,
div.parallaxmodule3.parallax-5 {
  background-image: url("<?php echo get_template_directory_uri(); ?>/img/5.jpg");
}

@media all and (min-width: 600px) {
  div.parallaxmodule h2 {
    font-size: 42px;
  }
  div.parallaxmodule p {
    font-size: 20px;
  }
  div.parallaxmodule.parallax h1 {
    font-size: 96px;
  }
}
@media all and (min-width: 960px) {
  div.parallaxmodule.parallax h1 {
    font-size: 80px;
    line-height:250px;
  }
}

/*Extra Styles*/

.site-title {
  display:none !important;
}

.introduction .content a,
.downloads .content .info .dl span,
.folio-button{
  background:transparent !important;
  border:solid 3px rgba(255, 255, 255, 0.8) !important;
    -webkit-transition: border 1s, color 1s; /* Safari 3.1 to 6.0 */
    transition: border 1s, color 1s;
}
.callout .content a,
.pricing-table .cta a {
  background:#FF0438;
  border-bottom:3px solid #C00028;
}

.introduction .content a:hover,
.downloads .content .info .dl span:hover,
.folio-button:hover{
  border:solid 3px #FF0438;
  color:#FF0438;
}

.features {
  background:transparent !important;
  border:3px solid #c5c5c5 !important;
}

.features .icon {
  display:none !important;
}

.imgsecone {
  background-image: url("<?php echo get_template_directory_uri(); ?>/img/sep1.png");  
}

.imgsectwo {
  background-image: url("<?php echo get_template_directory_uri(); ?>/img/sep2.png");  
}

.imgsecone,
.imgsectwo {
  width:100%;
  height:250px;
  -webkit-background-size: cover;
  -moz-background-size: cover;
  -o-background-size: cover;
  background-size: cover;
  background-repeat:no-repeat;
  z-index:2;
}

.alt {
  background:transparent !important;
}

.steps .item i,
.feature.landscape .info .item i{
  border:solid 1px #fff !important;
  background:transparent !important;
  border-bottom:solid 1px #fff !important;
}

.icon-mobile-phone:before {
  content:"" !important;
}

/*Pricing Plan Page*/
.page-header .box .title .entry-title,
.pricing-table h2,
.slogan h1 {
  color:#FF0438;
}

.page-header .breadcrumbs {
  display:none !important;
}

.introduction-video .content h1,
h4.aq-block-title {
  color:#ff0438 !important;
}

@media (min-width:768px){
  div.parallaxmodule3.parallax {
    background-position:100% 100%;
  }
}

@media (min-width:1200px) {

}

@media (min-width:992px) {

}

@media (min-width:480px) {

}

@media (min-width:320px) {

}

@media screen and (max-width:767px) {

}

@media screen and (-webkit-min-device-pixel-ratio:0) {

}

@media (max-device-width:480px)and (orientation:landscape){ 

}

@media (max-width:768px) {

}

@media (max-width:767px) {
  
}

@media screen and (min-width:768px) {
  
}

@media (min-width:992px){ 

}

@media all and (transform-3d) {

}

@media (min-width:768px)and (max-width:991px){

}

@media (min-width:992px)and (max-width:1199px) {

}



</style>

</head>



<body <?php body_class(); ?>>

<?php
  $plugin_dir = ABSPATH . 'wp-content/plugins/instaport-popup/';
  include_once ''.$plugin_dir.'popup-include.php';
?>


<div id="page" class="hfeed site">

	<?php do_action( 'before' ); ?>

	<header id="masthead" class="site-header" role="banner">

		<div class="site-branding">

		

			<?php 

		        if (isset($_COOKIE["px_ratio"])) {

		            $px_ratio = $_COOKIE["px_ratio"];

		            $logo = $px_ratio >= 2 ? $smof_data['logo_retina'] : $smof_data['logo'];

		        } else { 

		            $logo = $smof_data['logo']; 

		        }

	        ?>

			<?php 

				if ($smof_data['logo_text'] != 1) {

					?>

						<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img class="logo" src="<?php echo $logo; ?>" alt="<?php bloginfo( 'name' ); ?>" /></a>

					<?php

				} else {

					?>

						<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>

					<?php

				}

			?>

			

			

		</div>



		<nav id="site-navigation" class="main-navigation" role="navigation">

			<div class="screen-reader-text skip-link"><a href="#content" title="<?php esc_attr_e( 'Skip to content', 'pxs' ); ?>"><?php _e( 'Skip to content', 'pxs' ); ?></a></div>



			<?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_class' => 'sf-menu', ) ); ?>

		</nav><!-- #site-navigation -->

	</header><!-- #masthead -->



	<div id="content" class="site-content">