<?php
/**
 * Insta-Portfolio Pro functions and definitions
 *
 */
 
/**
 * Theme Options
 */


define('PXS_ADMIN_OPTIONS', get_template_directory() . '/inc/options/admin/functions/include/');
require_once(get_template_directory() . '/inc/options/admin/index.php');

/**
 * Set the content width based on the theme's design and stylesheet.
 */
if ( ! isset( $content_width ) )
	$content_width = 1140; /* pixels */

if ( ! function_exists( 'pxs_setup' ) ) :

function pxs_setup() {

	load_theme_textdomain( 'pxs', get_template_directory() . '/languages' );

	add_theme_support( 'automatic-feed-links' );

	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'pxs' ),
	) );

	add_theme_support( 'post-thumbnails' ); 

}
endif; // _s_setup
add_action( 'after_setup_theme', 'pxs_setup' );

/**
 * Register widgetized area and update sidebar with default widgets
 */
function pxs_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Sidebar', 'pxs' ),
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) );
}
add_action( 'widgets_init', 'pxs_widgets_init' );

/**
 * Enqueue scripts and styles
 */
function pxs_scripts() {

	global $smof_data;
	$color = $smof_data['gen_theme_colors'];

	/* Stylesheets */
	wp_enqueue_style( 'pxs-style', get_stylesheet_uri() );
	wp_enqueue_style( 'pxs-font-awsome', get_template_directory_uri() . '/css/stylesheets/font-awesome.css');
	wp_enqueue_style( 'pxs-flexslider', get_template_directory_uri() . '/css/flexslider.css');
	wp_enqueue_style( 'pxs-animate', get_template_directory_uri() . '/css/animate.css');
	wp_enqueue_style( 'superfish', get_template_directory_uri() . '/css/superfish.css');
	
	/* Theme Colors */
	if ($color == 'Light') { wp_enqueue_style('insta-light', get_template_directory_uri() . '/css/light.css'); }
	if ($color == 'Turquoise') { wp_enqueue_style('insta-turqoise', get_template_directory_uri() . '/css/turqoise.css'); }
	if ($color == 'Blue') { wp_enqueue_style('insta-blue', get_template_directory_uri() . '/css/blue.css'); }
	if ($color == 'Red') { wp_enqueue_style('insta-red', get_template_directory_uri() . '/css/red.css'); }
	if ($color == 'Purple') { wp_enqueue_style('insta-purple', get_template_directory_uri() . '/css/purple.css'); }
	if ($color == 'Dark') {/* use deafault */}

	/* Scripts */
	wp_enqueue_script( '_s-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20120206', true );
	wp_enqueue_script( '_s-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20130115', true );
	wp_enqueue_script('superfish', get_template_directory_uri() . '/js/superfish.js', array('jquery'), '20130209', true);
	wp_enqueue_script('superfish-subs', get_template_directory_uri() . '/js/supersubs.js', array('jquery'), '20130209', true);
	wp_enqueue_script('hoverintent', get_template_directory_uri() . '/js/hoverIntent.js', array('jquery'), '20130209', true);
	wp_enqueue_script('colornav', get_template_directory_uri() . '/js/colornav.js', array('jquery'), '20130209', true);
	wp_enqueue_script('mobile-menu', get_template_directory_uri() . '/js/mobmenu.js', array('jquery'), '20130209', true);
	
	wp_register_script('flexslider', get_template_directory_uri() . '/js/jquery.flexslider-min.js', array('jquery'), '20130209', true);
	wp_register_script('subscription', get_template_directory_uri() . '/js/hover-subscription.js', array('jquery'), '20130209', true);
	//wp_register_script('snaphshot', get_template_directory_uri() . '/js/hover-snapshot.js', array('jquery'), '20130209', true);
	wp_register_script('snaphshot1', get_template_directory_uri() . '/js/hover-snapshot1.js', array('jquery'), '20130209', true);
	wp_register_script('quovolver', get_template_directory_uri() . '/js/jquery.quovolver.js', array('jquery'), '20130209', true);
	
	wp_register_script('flexslider-settings', get_template_directory_uri() . '/js/flexslider-settings.js', array('jquery'), '20130209', true);
	wp_enqueue_script('snaphshot1');

	wp_enqueue_script('flexslider'); 
	    wp_enqueue_script('subscription');
	  
	    wp_enqueue_script('quovolver');

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'pxs_scripts' );

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

add_filter('show_admin_bar', '__return_false');

/**
 * PXS Blocks
 */
require get_template_directory() . '/page-builder/pxs-blocks.php';

/**
 * AQ Resizer
 */
require get_template_directory() . '/page-builder/aq_resizer.php';

/**
 * Breadcrumbs
 */
require_once(get_template_directory() . '/inc/breadcrumbs.php');

/**
 * Page Builder Custom CSS
 */
function aq_pagebuilder_admin_style() {
        wp_register_style( 'aq-page-builder', get_template_directory_uri() . '/page-builder/admin.css', false, '1.0.0' );
        wp_enqueue_style( 'aq-page-builder' );
}
add_action( 'admin_enqueue_scripts', 'aq_pagebuilder_admin_style' );

require_once('wp-updates-theme.php');
new WPUpdatesThemeUpdater_1446( 'http://wp-updates.com/api/2/theme', basename( get_template_directory() ) );

