<?php
/**
 * The template used for displaying blog posts
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	
	<div class="wrap">
	
		<div class="content">
	
			<header class="entry-header">
			
				<?php if ( has_post_thumbnail() && ! post_password_required() ) : ?>
					<div class="entry-thumbnail">
						<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
					</div>
				<?php endif; ?>
				
				<h1 class="entry-title"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h1>
				
			</header><!-- .entry-header -->
	
			<?php if ( is_search() ) : // Only display Excerpts for Search ?>
			
			<div class="entry-summary">
				<?php the_excerpt(); ?>
			</div><!-- .entry-summary -->
			
			<?php else : ?>
			
			<div class="entry-content">
				<?php the_excerpt( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'pxs' ) ); ?>
				<a href="<?php the_permalink(); ?>"> Read More</a>
				<?php
					wp_link_pages( array(
						'before' => '<div class="page-links">' . __( 'Pages:', 'pxs' ),
						'after'  => '</div>',
					) );
				?>
			</div><!-- .entry-content -->
		
			<?php endif; ?>
	
		</div><!-- .content -->
		
		<div class="meta">
	
			<div class="entry-meta date">
			
				<div class="info">
				
					<?php if ( 'post' == get_post_type() ) : // Hide category and tag text for pages on Search ?>
					
						<?php pxs_posted_on(); ?>
					
					<?php endif; // End if 'post' == get_post_type() ?>
					
				</div>
				
			</div><!-- .entry-meta date -->
			
			<div class="entry-meta tags">
				
				<div class="info">
				
					<?php if ( 'post' == get_post_type() ) : // Hide category and tag text for pages on Search ?>
						
						<?php
							/* translators: used between list items, there is a space after the comma */
							$categories_list = get_the_category_list( __( ', ', 'pxs' ) );
							if ( $categories_list && pxs_categorized_blog() ) :
						?>
						<span class="cats-link">
							<?php printf( __( '<i class="icon-tasks"></i> %1$s', 'pxs' ), $categories_list ); ?>
						</span>
						<?php endif; // End if categories ?>
			
						<?php
							/* translators: used between list items, there is a space after the comma */
							$tags_list = get_the_tag_list( '', __( ', ', '_s' ) );
							if ( $tags_list ) :
						?>
						<span class="tags-link">
							<?php printf( __( '<i class="icon-tags"></i> %1$s', 'pxs' ), $tags_list ); ?>
						</span>
						<?php endif; // End if $tags_list ?>
					<?php endif; // End if 'post' == get_post_type() ?>
					
						<span class="total-comments">
							 <i class="icon-comment"></i> <span> <?php comments_number( 'No comments', '1 comment', '% comments' ); ?> </span>
						</span>
				
				</div>
				
			</div><!-- .entry-meta tags -->
		
		</div>
	
	</div><!-- .wrap -->
	
</article><!-- #post-## -->
