<?php
/**
 * The template used for displaying single content in single.php
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="wrap">
	
		<div class="content single">
		
			<header class="entry-header">
			
				<?php if ( has_post_thumbnail() && ! post_password_required() ) : ?>
					<div class="entry-thumbnail">
						<?php the_post_thumbnail(); ?>
					</div>
				<?php endif; ?>
				
			</header><!-- .entry-header -->
	
			<div class="entry-content">
				<?php the_content(); ?>
			</div><!-- .entry-content -->
	
		</div>
		
		<div class="meta">
		
			<div class="entry-meta date">
			
				<div class="info">
				
					<?php if ( 'post' == get_post_type() ) : // Hide category and tag text for pages on Search ?>
					
						<?php pxs_posted_on(); ?>
					
					<?php endif; // End if 'post' == get_post_type() ?>
					
				</div>
				
			</div><!-- .entry-meta date -->
			
			<div class="entry-meta tags">
				
				<div class="info">
				
					<?php if ( 'post' == get_post_type() ) : // Hide category and tag text for pages on Search ?>
						
						<?php
							/* translators: used between list items, there is a space after the comma */
							$categories_list = get_the_category_list( __( ', ', 'pxs' ) );
							if ( $categories_list && pxs_categorized_blog() ) :
						?>
						<span class="cats-link">
							<?php printf( __( '<i class="icon-tasks"></i> %1$s', 'pxs' ), $categories_list ); ?>
						</span>
						<?php endif; // End if categories ?>
			
						<?php
							/* translators: used between list items, there is a space after the comma */
							$tags_list = get_the_tag_list( '', __( ', ', '_s' ) );
							if ( $tags_list ) :
						?>
						<span class="tags-link">
							<?php printf( __( '<i class="icon-tags"></i> %1$s', 'pxs' ), $tags_list ); ?>
						</span>
						<?php endif; // End if $tags_list ?>
					<?php endif; // End if 'post' == get_post_type() ?>
					
						<span class="total-comments">
							 <i class="icon-comment"></i> <span> <?php comments_number( 'No comments', '1 comment', '% comments' ); ?> </span>
						</span>
				
				</div>
				
			</div><!-- .entry-meta tags -->
		
		</div>
		
	</div>
	
	<?php
		wp_link_pages( array(
			'before' => '<div class="page-links">' . __( 'Pages:', 'pxs' ),
			'after'  => '</div>',
		) );
	?>
	
</article><!-- #post-## -->
