<?php
/**
 * Template Name: Blog
 *
 */
global $smof_data;
get_header(); ?>

	<div class="page-header">
	
		<div class="box">
		
			<div class="title">
				<h1 class="entry-title"><?php the_title(); ?></h1>
			</div>
			
			<div class="tagline">
				<p><?php bloginfo('description'); ?></p>
			</div>
		
		</div>
		
	</div>
	

	<div id="primary" class="content-area page">
	
		<?php 
			if($smof_data['layout_blog'] == 'sidebar-right') { ?>
				<main id="main" class="site-main" role="main">
		<?php } ?>
		
		<?php 
			if($smof_data['layout_blog'] == 'sidebar-left') { ?>
				<main id="main" class="site-main right" role="main">
		<?php } ?>
		
		<?php 
			if($smof_data['layout_blog'] == 'full-width') { ?>
				<main id="main" class="site-main fullwidth" role="main">
		<?php } ?>

		<?php
			$temp = $wp_query;
			$wp_query= null;
			$wp_query = new WP_Query();
			$wp_query->query('posts_per_page=5'.'&paged='.$paged);
			while ($wp_query->have_posts()) : $wp_query->the_post();
			?>

				<?php
					/* Include the Post-Format-specific template for the content.
					 * If you want to overload this in a child theme then include a file
					 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
					 */
					get_template_part( 'content', get_post_format() );
				?>

			<?php endwhile; ?>

			<?php pxs_content_nav( 'nav-below' ); ?>

			<?php $wp_query = null; $wp_query = $temp;?>

		</main><!-- #main -->
		
		<?php
			if($smof_data['layout_blog'] == 'sidebar-right') { ?>
				<div class="widgets right">
		<?php } ?>
		
		<?php
			if($smof_data['layout_blog'] == 'sidebar-left') { ?>
				<div class="widgets left">
		<?php } ?>

<?php
			if($smof_data['layout_blog'] == 'full-width') { ?>
				<div class="widgets hide">
		<?php } ?>
		
		<?php get_sidebar(); ?>
		</div>
		
	</div><!-- #primary -->
	
<?php get_footer(); ?>