<?php
/**
 * The template for displaying Archive pages.
 *
 *
 */

get_header(); ?>

	<div class="page-header">
	
		<div class="box">
		
			<div class="title">
				<h1 class="entry-title">
					<?php
						if ( is_category() ) :
							single_cat_title();
		
						elseif ( is_tag() ) :
							single_tag_title();
		
						elseif ( is_author() ) :
							the_post();
							printf( __( 'Author: %s', 'pxs' ), '<span class="vcard">' . get_the_author() . '</span>' );
							rewind_posts();
		
						elseif ( is_day() ) :
							printf( __( 'Day: %s', 'pxs' ), '<span>' . get_the_date() . '</span>' );
		
						elseif ( is_month() ) :
							printf( __( 'Month: %s', 'pxs' ), '<span>' . get_the_date( 'F Y' ) . '</span>' );
		
						elseif ( is_year() ) :
							printf( __( 'Year: %s', 'pxs' ), '<span>' . get_the_date( 'Y' ) . '</span>' );
		
						elseif ( is_tax( 'post_format', 'post-format-aside' ) ) :
							_e( 'Asides', '_s' );
		
						elseif ( is_tax( 'post_format', 'post-format-image' ) ) :
							_e( 'Images', '_s');
		
						elseif ( is_tax( 'post_format', 'post-format-video' ) ) :
							_e( 'Videos', '_s' );
		
						elseif ( is_tax( 'post_format', 'post-format-quote' ) ) :
							_e( 'Quotes', '_s' );
		
						elseif ( is_tax( 'post_format', 'post-format-link' ) ) :
							_e( 'Links', '_s' );
		
						else :
							_e( 'Archives', 'pxs' );
		
						endif;
					?>
				</h1>
			</div>
			
			<div class="breadcrumbs">
				<?php dimox_breadcrumbs(); ?>
			</div>
		
		</div>
		
		<?php
			// Show an optional term description.
			$term_description = term_description();
			if ( ! empty( $term_description ) ) :
				printf( '<div class="taxonomy-description">%s</div>', $term_description );
			endif;
		?>
	</div><!-- .page-header -->

	<section id="primary" class="content-area page">
		<main id="main" class="site-main" role="main">

		<?php if ( have_posts() ) : ?>

			<?php /* Start the Loop */ ?>
			<?php while ( have_posts() ) : the_post(); ?>

				<?php
					/* Include the Post-Format-specific template for the content.
					 * If you want to overload this in a child theme then include a file
					 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
					 */
					get_template_part( 'content', get_post_format() );
				?>

			<?php endwhile; ?>

			<?php pxs_content_nav( 'nav-below' ); ?>

		<?php else : ?>

			<?php get_template_part( 'no-results', 'archive' ); ?>

		<?php endif; ?>

		</main><!-- #main -->
		
		<?php get_sidebar(); ?>
		
	</section><!-- #primary -->

<?php get_footer(); ?>
