<?php
/*
  Plugin Name: Shock Spots
  Description: Shock Spots
  Author: IKKONIK
  Author URI: http://ikkonik.net/
  Version: 1.0
 * 
 * Copyright by IKKONIK
 */

class ShockSpots {

    function adminMenu() {
        $url = plugin_dir_url(__FILE__);
        add_menu_page('Shock Spots', 'Shock Spots', 'edit_pages', 'shock_spots', array($this, 'shortcode_edit'), $url . 'images/Iconblue.png');
        if ($this->checkLicence()) {
            add_submenu_page('shock_spots', 'Add new', 'Add new', 'edit_pages', 'post-new.php?post_type=shock_spot');
            add_submenu_page('shock_spots', 'Shortcode', 'Shortcode', 'edit_pages', 'edit.php?post_type=shock_spot');
        }

        //add_submenu_page('shock_spots', 'Licence Key', 'Licence Key', 'manage_options', 'licence_key', array($this, 'licence_key'));
    }

    function licence_key() {
        if (isset($_POST['save_licence'])) {
            update_option('shock_spots_licence_key', $_POST['licence_key']);
            ?>
            <script>
                window.location = 'admin.php?page=licence_key';
            </script>
            <?php
            die();
        }
        require dirname(__FILE__) . '/tmpl/licence.php';
    }

    function shortcode_edit() {
        if (!$this->checkLicence()) {
            ?>
            <script type="text/javascript">
                window.location = 'admin.php?page=licence_key';
            </script>
            <?php
        } else {
            ?>
            <script type="text/javascript">
                window.location = 'edit.php?post_type=shock_spot';
            </script>
            <?php
        }
        die();
    }

    function metabox($post) {
        $url = plugin_dir_url(__FILE__);
        require_once dirname(__FILE__) . '/tmpl/metabox.php';
    }

    function savePost($post_id) {
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return;
        }

        if (isset($_POST['post_type']) && $_POST['post_type'] == 'shock_spot') {
            if (!current_user_can('edit_page', $post_id)) {
                return;
            }
            update_post_meta($post_id, 'affiliate_1', $_POST['affiliate_1']);
            update_post_meta($post_id, 'ad_text_1', $_POST['ad_text_1']);
            update_post_meta($post_id, 'position_1', $_POST['position_1']);
            update_post_meta($post_id, 'picture_1', $_POST['picture_1']);
            update_post_meta($post_id, 'affiliate_2', $_POST['affiliate_2']);
            update_post_meta($post_id, 'ad_text_2', $_POST['ad_text_2']);
            update_post_meta($post_id, 'position_2', $_POST['position_2']);
            update_post_meta($post_id, 'picture_2', $_POST['picture_2']);
            update_post_meta($post_id, 'crop_1', $_POST['crop_1']);
            update_post_meta($post_id, 'crop_2', $_POST['crop_2']);
        }
    }

    function notice_empty() {
        ?>
        <div class="error">
            <p><b>Shock Spots</b> plugin requires a licence key! <a href="admin.php?page=licence_key">Click here</a> to provide it.</p>
        </div>
        <?php
    }

    function notice_invalid() {
        ?>
        <div class="error">
            <p><b>Shock Spots</b> the currently provided key is invalid. <a href="admin.php?page=licence_key">Click here</a> to correct it.</p>
        </div>
        <?php
    }

    function getCurl() {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($curl, CURLOPT_REFERER, 'http://google.pl');
        curl_setopt($curl, CURLOPT_USERAGENT, 'Mozilla/6.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.1) Gecko/20061204 Firefox/2.0.0.1');
        curl_setopt($curl, CURLOPT_COOKIEFILE, dirname(__FILE__) . '/cookies.txt');
        curl_setopt($curl, CURLOPT_COOKIEJAR, dirname(__FILE__) . '/cookies.txt');
        curl_setopt($curl, CURLOPT_AUTOREFERER, true);
        curl_setopt($curl, CURLOPT_VERBOSE, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        return $curl;
    }

    function checkLicence() {
        return true;
        $key = get_option('shock_spots_licence_key');
        if (trim($key) == '') {
            add_action('admin_notices', array($this, 'notice_empty'));
            return false;
        }

        /* try via api */
        $server = 'http://ikkonik.net/';
        $curl = $this->getCurl();
        $domain = $_SERVER['HTTP_HOST'];
        curl_setopt($curl, CURLOPT_URL, $server);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, array('key_check' => $key, 'domain' => $domain));
        $result = curl_exec($curl);

        if ($result == 'valid') {
            return true;
        } else {
            add_action('admin_notices', array($this, 'notice_invalid'));
            return false;
        }

        return false;
    }

    function add_tinymce_plugin($plugin_array) {
        $plugin_array['tc_button'] = plugins_url('/js/button.js', __FILE__); // CHANGE THE BUTTON SCRIPT HERE
        return $plugin_array;
    }

    function register_my_tc_button($buttons) {
        array_push($buttons, "tc_button");
        return $buttons;
    }

    function add_button() {
        global $typenow;
        // check user permissions
        if (!current_user_can('edit_posts') && !current_user_can('edit_pages')) {
            return;
        }

        // check if WYSIWYG is enabled
        if (get_user_option('rich_editing') == 'true') {
            add_filter("mce_external_plugins", array($this, 'add_tinymce_plugin'));
            add_filter('mce_buttons', array($this, 'register_my_tc_button'));
            $all = get_posts(array(
                'posts_per_page' => -1,
                'post_type' => 'shock_spot',
                'orderby' => 'title'
            ));
            $json = array();
            foreach ($all as $k => $a) {
                $json[] = array('text' => $a->post_title, 'value' => '[shock_spots id="' . $a->ID . '"]');
            }
            ?>
            <script type="text/javascript">
                json_menus = <?php echo json_encode($json) ?>

            </script>

            <?php
        }
    }
  

    function init() {

        $check = $this->checkLicence();

        if ($check) {
            add_shortcode('shock_spots', array($this, 'shortcode'));
            add_action('admin_head', array($this, 'add_button'));
        }

        wp_enqueue_style('hp_admin_cssf', plugin_dir_url(__FILE__) . 'css/front.css', array(), rand(1, 1000));
        add_action('admin_menu', array($this, 'adminMenu'));

        register_post_type('shock_spot', array(
            'labels' => array(
                'name' => __('Shock Spot'),
                'singular_name' => __('Shock Spot'),
                'add_new' => 'Add Shock Spot',
                'add_new_item' => 'Add Shock Spot',
                'edit_item' => 'Edit Shock Spot',
                'view_item' => 'View Shock Spot'),
            'public' => true,
            'has_archive' => true,
            'hierarchical' => true,
            'exclude_from_search' => true,
            'show_in_nav_menus' => false,
            'show_in_menu' => false,
            'taxonomies' => array(),
            'supports' => array('title', 'thumbnail')
        ));

        add_filter('manage_shock_spot_posts_columns', array($this, 'addColumn'));
        add_action('manage_shock_spot_posts_custom_column', array($this, 'setColumn'), 10, 2);
    }

    function addColumn($columns) {
        return array(
            'cb' => '"<input type="checkbox" />',
            'title' => 'Name',
            'thumbnail' => 'Thumbnail',
            'date' => 'Created',
            'shortcode' => 'Shortcode'
        );
    }

    function setColumn($column, $post_id) {
        if ($column == 'shortcode') {
            ?>
            <input type="text" readonly="readonly" value='[shock_spots id="<?php echo $post_id ?>"]' />
            <style>
                .view,.editinline
                {
                    display:none;
                }                
            </style>
            <?php
        }
        if ($column == 'thumbnail') {
            $crop1 = get_post_meta($post_id, 'crop_1', true);
            $crop2 = get_post_meta($post_id, 'crop_2', true);
            if ($crop1):
                ?>
                <img src="<?php echo $crop1 ?>" class="" />
            <?php endif ?>
            <?php if ($crop2): ?>
                <img src="<?php echo $crop2 ?>" class="" />
            <?php endif ?>

            <?php
        }
    }

    function shortcode($args) {
        ob_start();
        if (isset($args['id'])) {
            $id = $args['id'];
            require dirname(__FILE__) . '/tmpl/shortcode.php';
        }
        return ob_get_clean();
    }

    function prepareAdmin() {
        
        wp_enqueue_style('hp_component', plugin_dir_url(__FILE__) . 'js/image_resize/css/component.css', array(), rand(1, 1000));
        wp_enqueue_style('hp_normalize', plugin_dir_url(__FILE__) . 'js/image_resize/css/normalize.css', array(), rand(1, 1000));
        wp_enqueue_style('hp_res', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.11.3/themes/smoothness/jquery-ui.css', array(), rand(1, 1000));

        wp_enqueue_style('hp_admin_css', plugin_dir_url(__FILE__) . 'css/admin.css', array(), rand(1, 1000));

        add_action('save_post', array($this, 'savePost'));
        add_meta_box('id', 'Settings', array($this, 'metabox'), 'shock_spot', 'normal', 'high');

        $post_id = $_GET['post'] ? $_GET['post'] : $_POST['post_ID'];
        


        $post_edited = get_post($post_id);

        if ($post_edited->post_type == 'shock_spot' || $_GET['post_type']=='shock_spot') {
            wp_enqueue_script('hp_components', plugin_dir_url(__FILE__) . 'js/image_resize/js/component.js', array(), rand(1, 1000));
        
            wp_enqueue_script('jqui', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.11.3/jquery-ui.min.js', array(), rand(1, 1000));

            wp_enqueue_script('hp_admin_js', plugin_dir_url(__FILE__) . 'js/admin.js', array(), rand(1, 1000));
        
            add_filter('wp_default_editor', create_function('', 'return "tinymce";'));
            add_filter('tiny_mce_before_init', array($this, 'tinymceBeforeInit'));
        }
    }

    function tinymceBeforeInit($initArray) {
        ob_start();
        require dirname(__FILE__).'/js/event.js';
        $js = ob_get_clean();
        $initArray['setup'] = $js;
        return $initArray;
    }

}

$ShockSports = new ShockSpots();

add_action('init', array($ShockSports, 'init'));
add_action('admin_init', array($ShockSports, 'prepareAdmin'));
add_filter('gettext', 'change_publish_button', 10, 2);

function change_publish_button($translation, $text) {

    global $typenow;
    if ($text == 'Publish' && $typenow == 'shock_spot') {
        return 'Save';
    }
    return $translation;
}
