if (window.location.protocol == 'file:') {
    alert('To test this demo properly please use a local server such as XAMPP or WAMP. See README.md for more details.');
}

var selectedContainer = false;

var resizeableImage = function (wrapper) {
    // Some variable and settings

    /*check*/

    if (jQuery(wrapper).find('img').length === 0)
    {
        return false;
    }
    jQuery(wrapper).parent().css('display', 'block');


    var rel = wrapper.attr('rel');

    var $container,
            cropWrapper,
            orig_src = new Image(),
            image_target = jQuery(wrapper).find('img').get(0),
            event_state = {},
            constrain = false,
            min_width = 60, // Change as required
            min_height = 60,
            max_width = 800, // Change as required
            max_height = 900,
            resize_canvas = document.createElement('canvas');
    cropWrapper = wrapper.find('.cropped');
    init = function () {

        // When resizing, we will always use this copy of the original as the base
        orig_src.src = image_target.src;


        $container = jQuery(wrapper).find('.resize-container');

        //wrapper.find('img').on('mousedown touchstart', startMoving);
        try {
            $container.resizable("destroy");
            $container.draggable("destroy");
        } catch (exception) {
        }

        $container.resizable();
        $container.draggable();
        $container.on("resize", function (event, ui) {
            var width = ui.size.width;
            var height = ui.size.height;
            $container.find('img').css('height', ui.size.height);
            $container.find('img').css('width', ui.size.width);
            
            resize_canvas.width = width;
            resize_canvas.height = height;
            resize_canvas.getContext('2d').drawImage(orig_src, 0, 0, width, height);
            jQuery(image_target).attr('src', resize_canvas.toDataURL("image/png"));
            
        });
        wrapper.find('.js-crop').on('click', crop);
    };

    startResize = function (e) {
        selectedContainer = $container;
        e.preventDefault();
        e.stopPropagation();
        saveEventState(e);
        jQuery(document).on('mousemove touchmove', resizing);
        jQuery(document).on('mouseup touchend', endResize);
    };

    endResize = function (e) {
        e.preventDefault();
        jQuery(document).off('mouseup touchend', endResize);
        jQuery(document).off('mousemove touchmove', resizing);
    };

    saveEventState = function (e) {
        // Save the initial event details and container state
        event_state.container_width = selectedContainer.width();
        event_state.container_height = selectedContainer.height();

        event_state.container_left = parseInt(selectedContainer.css('left'));
        event_state.container_top = parseInt(selectedContainer.css('top'));

        if (isNaN(event_state.container_left))
        {
            event_state.container_left = 0;
        }
        if (isNaN(event_state.container_top))
        {
            event_state.container_top = 0;
        }

        event_state.mouse_x = (e.clientX || e.pageX || e.originalEvent.touches[0].clientX) + jQuery(window).scrollLeft();
        event_state.mouse_y = (e.clientY || e.pageY || e.originalEvent.touches[0].clientY) + jQuery(window).scrollTop();

        // This is a fix for mobile safari
        // For some reason it does not allow a direct copy of the touches property
        if (typeof e.originalEvent.touches !== 'undefined') {
            event_state.touches = [];
            $.each(e.originalEvent.touches, function (i, ob) {
                event_state.touches[i] = {};
                event_state.touches[i].clientX = 0 + ob.clientX;
                event_state.touches[i].clientY = 0 + ob.clientY;
            });
        }
        event_state.evnt = e;
    };

    moving = function (e) {

        var mouse = {}, touches;
        e.preventDefault();
        e.stopPropagation();

        touches = e.originalEvent.touches;

        mouse.x = (e.clientX || e.pageX || touches[0].clientX) + jQuery(window).scrollLeft();
        mouse.y = (e.clientY || e.pageY || touches[0].clientY) + jQuery(window).scrollTop();

        selectedContainer.css('left', mouse.x - event_state.mouse_x + event_state.container_left);
        selectedContainer.css('top', mouse.y - event_state.mouse_y + event_state.container_top);

        // Watch for pinch zoom gesture while moving
        if (event_state.touches && event_state.touches.length > 1 && touches.length > 1) {
            var width = event_state.container_width, height = event_state.container_height;
            var a = event_state.touches[0].clientX - event_state.touches[1].clientX;
            a = a * a;
            var b = event_state.touches[0].clientY - event_state.touches[1].clientY;
            b = b * b;
            var dist1 = Math.sqrt(a + b);

            a = e.originalEvent.touches[0].clientX - touches[1].clientX;
            a = a * a;
            b = e.originalEvent.touches[0].clientY - touches[1].clientY;
            b = b * b;
            var dist2 = Math.sqrt(a + b);

            var ratio = dist2 / dist1;

            width = width * ratio;
            height = height * ratio;
            // To improve performance you might limit how often resizeImage() is called
            resizeImage(width, height);
        }
    };

    resizing = function (e) {
        var mouse = {}, width, height, left, top, offset = selectedContainer.offset();
        mouse.x = (e.clientX || e.pageX || e.originalEvent.touches[0].clientX) + jQuery(window).scrollLeft();
        mouse.y = (e.clientY || e.pageY || e.originalEvent.touches[0].clientY) + jQuery(window).scrollTop();

        // Position image differently depending on the corner dragged and constraints

        console.log(mouse.x);
        console.log(event_state.container_left);
        console.log(event_state.container_width);
        console.log('--------');

        if (jQuery(event_state.evnt.target).hasClass('resize-handle-se')) {
            width = mouse.x - event_state.container_left;
            height = mouse.y - event_state.container_top;
            left = event_state.container_left;
            top = event_state.container_top;
        } else if (jQuery(event_state.evnt.target).hasClass('resize-handle-sw')) {
            width = event_state.container_width - (mouse.x - event_state.container_left);
            height = mouse.y - event_state.container_top;
            left = mouse.x;
            top = event_state.container_top;
        } else if (jQuery(event_state.evnt.target).hasClass('resize-handle-nw')) {
            width = event_state.container_width - (mouse.x - event_state.container_left);
            height = event_state.container_height - (mouse.y - event_state.container_top);
            left = mouse.x;
            top = mouse.y;
            if (constrain || e.shiftKey) {
                top = mouse.y - ((width / orig_src.width * orig_src.height) - height);
            }
        } else if (jQuery(event_state.evnt.target).hasClass('resize-handle-ne')) {
            width = mouse.x - event_state.container_left;
            height = event_state.container_height - (mouse.y - event_state.container_top);
            left = event_state.container_left;
            top = mouse.y;
            if (constrain || e.shiftKey) {
                top = mouse.y - ((width / orig_src.width * orig_src.height) - height);
            }
        }


        // Optionally maintain aspect ratio
        if (constrain || e.shiftKey) {
            height = width / orig_src.width * orig_src.height;
        }

        if (width > min_width && height > min_height && width < max_width && height < max_height) {
            // To improve performance you might limit how often resizeImage() is called
            resizeImage(width, height);
            // Without this Firefox will not re-calculate the the image dimensions until drag end

            selectedContainer.position({'left': left, 'top': top});

            /*selectedContainer.css('left',left);
             selectedContainer.css('top', top  );*/
        }
    }

    resizeImage = function (width, height, resize_canvas) {
       
    };

    startMoving = function (e) {

        selectedContainer = $container;

        e.preventDefault();
        e.stopPropagation();
        saveEventState(e);
        jQuery(document).on('mousemove touchmove', moving);
        jQuery(document).on('mouseup touchend', endMoving);
    };

    endMoving = function (e) {

        e.preventDefault();
        jQuery(document).off('mouseup touchend', endMoving);
        jQuery(document).off('mousemove touchmove', moving);
    };



    crop = function (e) {
        //Find the part of the image that is inside the crop box

        e.preventDefault();

        var crop_canvas,
                left = wrapper.find('.overlay').offset().left - $container.offset().left,
                top = wrapper.find('.overlay').offset().top - $container.offset().top,
                width = wrapper.find('.overlay').width(),
                height = wrapper.find('.overlay').height();

        crop_canvas = document.createElement('canvas');
        crop_canvas.width = width;
        crop_canvas.height = height;

        crop_canvas.getContext('2d').drawImage(image_target, left, top, width, height, 0, 0, width, height);
        var data = crop_canvas.toDataURL("image/png");
        cropWrapper.html('');
        var rel = cropWrapper.parent().attr('rel');
        cropWrapper.append(jQuery('<img src="' + data + '"></img>'));
        cropWrapper.append(jQuery('<input type="hidden" name="crop_' + rel + '" value="' + data + '"></img>'));

        ////window.open(crop_canvas.toDataURL("image/png"));
    };

    init();
};
