/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.exceptions.SerializationException;
import com.netflix.astyanax.serializers.AbstractSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;

public class ObjectSerializer
extends AbstractSerializer<Object>
implements Serializer<Object> {
    private static final ObjectSerializer INSTANCE = new ObjectSerializer();

    @Override
    public ByteBuffer toByteBuffer(Object obj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.close();
            return ByteBuffer.wrap(baos.toByteArray());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Object fromByteBuffer(ByteBuffer bytes) {
        if (bytes == null || !bytes.hasRemaining()) {
            return null;
        }
        try {
            int l = bytes.remaining();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes.array(), bytes.arrayOffset() + bytes.position(), l);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object obj = ois.readObject();
            bytes.position(bytes.position() + (l - ois.available()));
            ois.close();
            return obj;
        }
        catch (Exception ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    public static ObjectSerializer get() {
        return INSTANCE;
    }
}

