/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.serializers.AbstractSerializer;
import com.netflix.astyanax.serializers.ComparatorType;
import com.netflix.astyanax.serializers.IntegerSerializer;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.FloatType;

public class FloatSerializer
extends AbstractSerializer<Float> {
    private static final FloatSerializer instance = new FloatSerializer();

    public static FloatSerializer get() {
        return instance;
    }

    @Override
    public ByteBuffer toByteBuffer(Float obj) {
        return IntegerSerializer.get().toByteBuffer(Float.floatToRawIntBits(obj.floatValue()));
    }

    @Override
    public Float fromByteBuffer(ByteBuffer bytes) {
        return Float.valueOf(Float.intBitsToFloat(IntegerSerializer.get().fromByteBuffer(bytes)));
    }

    @Override
    public ByteBuffer fromString(String str) {
        return FloatType.instance.fromString(str);
    }

    @Override
    public String getString(ByteBuffer byteBuffer) {
        return FloatType.instance.getString(byteBuffer);
    }

    @Override
    public ByteBuffer getNext(ByteBuffer byteBuffer) {
        float val = this.fromByteBuffer(byteBuffer.duplicate()).floatValue();
        if (val == Float.MAX_VALUE) {
            throw new ArithmeticException("Can't paginate past max float");
        }
        return this.toByteBuffer(Float.valueOf(val + Float.MIN_VALUE));
    }

    @Override
    public ComparatorType getComparatorType() {
        return ComparatorType.FLOATTYPE;
    }
}

