/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.serializers.AbstractSerializer;
import java.nio.ByteBuffer;

public class CharSerializer
extends AbstractSerializer<Character> {
    private static final CharSerializer instance = new CharSerializer();

    public static CharSerializer get() {
        return instance;
    }

    @Override
    public ByteBuffer toByteBuffer(Character obj) {
        if (obj == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putChar(obj.charValue());
        buffer.rewind();
        return buffer;
    }

    @Override
    public Character fromByteBuffer(ByteBuffer bytes) {
        if (bytes == null) {
            return null;
        }
        return Character.valueOf(bytes.getChar());
    }

    @Override
    public ByteBuffer fromString(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        return this.toByteBuffer(Character.valueOf(str.charAt(0)));
    }

    @Override
    public String getString(ByteBuffer byteBuffer) {
        return this.fromByteBuffer(byteBuffer).toString();
    }

    @Override
    public ByteBuffer getNext(ByteBuffer byteBuffer) {
        throw new IllegalStateException("Char columns can't be paginated");
    }
}

