/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.serializers.AbstractSerializer;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.BytesType;

public final class BytesArraySerializer
extends AbstractSerializer<byte[]>
implements Serializer<byte[]> {
    private static final BytesArraySerializer instance = new BytesArraySerializer();

    public static BytesArraySerializer get() {
        return instance;
    }

    @Override
    public ByteBuffer toByteBuffer(byte[] obj) {
        if (obj == null) {
            return null;
        }
        return ByteBuffer.wrap(obj);
    }

    @Override
    public byte[] fromByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes, 0, bytes.length);
        return bytes;
    }

    @Override
    public ByteBuffer fromString(String str) {
        return BytesType.instance.fromString(str);
    }

    @Override
    public String getString(ByteBuffer byteBuffer) {
        return BytesType.instance.getString(byteBuffer);
    }
}

