/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class CellUtil {
    public static ByteRange fillRowRange(Cell cell, ByteRange range) {
        return range.set(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
    }

    public static ByteRange fillFamilyRange(Cell cell, ByteRange range) {
        return range.set(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
    }

    public static ByteRange fillQualifierRange(Cell cell, ByteRange range) {
        return range.set(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
    }

    public static ByteRange fillTagRange(Cell cell, ByteRange range) {
        return range.set(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
    }

    public static byte[] cloneRow(Cell cell) {
        byte[] output = new byte[cell.getRowLength()];
        CellUtil.copyRowTo(cell, output, 0);
        return output;
    }

    public static byte[] cloneFamily(Cell cell) {
        byte[] output = new byte[cell.getFamilyLength()];
        CellUtil.copyFamilyTo(cell, output, 0);
        return output;
    }

    public static byte[] cloneQualifier(Cell cell) {
        byte[] output = new byte[cell.getQualifierLength()];
        CellUtil.copyQualifierTo(cell, output, 0);
        return output;
    }

    public static byte[] cloneValue(Cell cell) {
        byte[] output = new byte[cell.getValueLength()];
        CellUtil.copyValueTo(cell, output, 0);
        return output;
    }

    public static byte[] getTagArray(Cell cell) {
        byte[] output = new byte[cell.getTagsLength()];
        CellUtil.copyTagTo(cell, output, 0);
        return output;
    }

    public static int copyRowTo(Cell cell, byte[] destination, int destinationOffset) {
        System.arraycopy(cell.getRowArray(), cell.getRowOffset(), destination, destinationOffset, cell.getRowLength());
        return destinationOffset + cell.getRowLength();
    }

    public static int copyFamilyTo(Cell cell, byte[] destination, int destinationOffset) {
        System.arraycopy(cell.getFamilyArray(), cell.getFamilyOffset(), destination, destinationOffset, cell.getFamilyLength());
        return destinationOffset + cell.getFamilyLength();
    }

    public static int copyQualifierTo(Cell cell, byte[] destination, int destinationOffset) {
        System.arraycopy(cell.getQualifierArray(), cell.getQualifierOffset(), destination, destinationOffset, cell.getQualifierLength());
        return destinationOffset + cell.getQualifierLength();
    }

    public static int copyValueTo(Cell cell, byte[] destination, int destinationOffset) {
        System.arraycopy(cell.getValueArray(), cell.getValueOffset(), destination, destinationOffset, cell.getValueLength());
        return destinationOffset + cell.getValueLength();
    }

    public static int copyTagTo(Cell cell, byte[] destination, int destinationOffset) {
        System.arraycopy(cell.getTagsArray(), cell.getTagsOffset(), destination, destinationOffset, cell.getTagsLength());
        return destinationOffset + cell.getTagsLength();
    }

    public static byte getRowByte(Cell cell, int index) {
        return cell.getRowArray()[cell.getRowOffset() + index];
    }

    public static ByteBuffer getValueBufferShallowCopy(Cell cell) {
        ByteBuffer buffer = ByteBuffer.wrap(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
        return buffer;
    }

    public static ByteBuffer getQualifierBufferShallowCopy(Cell cell) {
        ByteBuffer buffer = ByteBuffer.wrap(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
        return buffer;
    }

    public static Cell createCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte type, byte[] value) {
        return new KeyValue(row, family, qualifier, timestamp, KeyValue.Type.codeToType(type), value);
    }

    public static Cell createCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte type, byte[] value, long memstoreTS) {
        KeyValue keyValue = new KeyValue(row, family, qualifier, timestamp, KeyValue.Type.codeToType(type), value);
        keyValue.setMvccVersion(memstoreTS);
        return keyValue;
    }

    public static Cell createCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte type, byte[] value, byte[] tags, long memstoreTS) {
        KeyValue keyValue = new KeyValue(row, family, qualifier, timestamp, KeyValue.Type.codeToType(type), value, tags);
        keyValue.setMvccVersion(memstoreTS);
        return keyValue;
    }

    public static Cell createCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, KeyValue.Type type, byte[] value, byte[] tags) {
        KeyValue keyValue = new KeyValue(row, family, qualifier, timestamp, type, value, tags);
        return keyValue;
    }

    public static CellScanner createCellScanner(final List<? extends CellScannable> cellScannerables) {
        return new CellScanner(){
            private final Iterator<? extends CellScannable> iterator;
            private CellScanner cellScanner;
            {
                this.iterator = cellScannerables.iterator();
                this.cellScanner = null;
            }

            @Override
            public Cell current() {
                return this.cellScanner != null ? this.cellScanner.current() : null;
            }

            @Override
            public boolean advance() throws IOException {
                if (this.cellScanner == null) {
                    if (!this.iterator.hasNext()) {
                        return false;
                    }
                    this.cellScanner = this.iterator.next().cellScanner();
                }
                if (this.cellScanner.advance()) {
                    return true;
                }
                this.cellScanner = null;
                return this.advance();
            }
        };
    }

    public static CellScanner createCellScanner(Iterable<Cell> cellIterable) {
        if (cellIterable == null) {
            return null;
        }
        return CellUtil.createCellScanner(cellIterable.iterator());
    }

    public static CellScanner createCellScanner(final Iterator<Cell> cells) {
        if (cells == null) {
            return null;
        }
        return new CellScanner(){
            private final Iterator<Cell> iterator;
            private Cell current;
            {
                this.iterator = cells;
                this.current = null;
            }

            @Override
            public Cell current() {
                return this.current;
            }

            @Override
            public boolean advance() {
                boolean hasNext = this.iterator.hasNext();
                this.current = hasNext ? this.iterator.next() : null;
                return hasNext;
            }
        };
    }

    public static CellScanner createCellScanner(final Cell[] cellArray) {
        return new CellScanner(){
            private final Cell[] cells;
            private int index;
            {
                this.cells = cellArray;
                this.index = -1;
            }

            @Override
            public Cell current() {
                if (this.cells == null) {
                    return null;
                }
                return this.index < 0 ? null : this.cells[this.index];
            }

            @Override
            public boolean advance() {
                if (this.cells == null) {
                    return false;
                }
                return ++this.index < this.cells.length;
            }
        };
    }

    public static CellScanner createCellScanner(final NavigableMap<byte[], List<Cell>> map) {
        return new CellScanner(){
            private final Iterator<Map.Entry<byte[], List<Cell>>> entries;
            private Iterator<Cell> currentIterator;
            private Cell currentCell;
            {
                this.entries = map.entrySet().iterator();
                this.currentIterator = null;
            }

            @Override
            public Cell current() {
                return this.currentCell;
            }

            @Override
            public boolean advance() {
                if (this.currentIterator == null) {
                    if (!this.entries.hasNext()) {
                        return false;
                    }
                    this.currentIterator = this.entries.next().getValue().iterator();
                }
                if (this.currentIterator.hasNext()) {
                    this.currentCell = this.currentIterator.next();
                    return true;
                }
                this.currentCell = null;
                this.currentIterator = null;
                return this.advance();
            }
        };
    }

    public static boolean matchingRow(Cell left, Cell right) {
        return Bytes.equals(left.getRowArray(), left.getRowOffset(), left.getRowLength(), right.getRowArray(), right.getRowOffset(), right.getRowLength());
    }

    public static boolean matchingRow(Cell left, byte[] buf) {
        return Bytes.equals(left.getRowArray(), left.getRowOffset(), left.getRowLength(), buf, 0, buf.length);
    }

    public static boolean matchingFamily(Cell left, Cell right) {
        return Bytes.equals(left.getFamilyArray(), left.getFamilyOffset(), left.getFamilyLength(), right.getFamilyArray(), right.getFamilyOffset(), right.getFamilyLength());
    }

    public static boolean matchingFamily(Cell left, byte[] buf) {
        return Bytes.equals(left.getFamilyArray(), left.getFamilyOffset(), left.getFamilyLength(), buf, 0, buf.length);
    }

    public static boolean matchingQualifier(Cell left, Cell right) {
        return Bytes.equals(left.getQualifierArray(), left.getQualifierOffset(), left.getQualifierLength(), right.getQualifierArray(), right.getQualifierOffset(), right.getQualifierLength());
    }

    public static boolean matchingQualifier(Cell left, byte[] buf) {
        return Bytes.equals(left.getQualifierArray(), left.getQualifierOffset(), left.getQualifierLength(), buf, 0, buf.length);
    }

    public static boolean matchingColumn(Cell left, Cell right) {
        if (!CellUtil.matchingFamily(left, right)) {
            return false;
        }
        return CellUtil.matchingQualifier(left, right);
    }

    public static boolean matchingValue(Cell left, Cell right) {
        return Bytes.equals(left.getValueArray(), left.getValueOffset(), left.getValueLength(), right.getValueArray(), right.getValueOffset(), right.getValueLength());
    }

    public static boolean matchingValue(Cell left, byte[] buf) {
        return Bytes.equals(left.getValueArray(), left.getValueOffset(), left.getValueLength(), buf, 0, buf.length);
    }

    public static boolean isDelete(Cell cell) {
        return KeyValue.isDelete(cell.getTypeByte());
    }

    public static boolean isDeleteFamily(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteFamily.getCode();
    }

    public static int estimatedSizeOf(Cell cell) {
        if (cell instanceof KeyValue) {
            return ((KeyValue)cell).getLength() + 4;
        }
        return cell.getRowLength() + cell.getFamilyLength() + cell.getQualifierLength() + cell.getValueLength() + 12 + 4;
    }

    public static Iterator<Tag> tagsIterator(final byte[] tags, final int offset, final int length) {
        return new Iterator<Tag>(){
            private int pos;
            private int endOffset;
            {
                this.pos = offset;
                this.endOffset = offset + length - 1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.endOffset;
            }

            @Override
            public Tag next() {
                if (this.hasNext()) {
                    short curTagLen = Bytes.toShort(tags, this.pos);
                    Tag tag = new Tag(tags, this.pos, (short)(curTagLen + 2));
                    this.pos += 2 + curTagLen;
                    return tag;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static boolean overlappingKeys(byte[] start1, byte[] end1, byte[] start2, byte[] end2) {
        return !(end2.length != 0 && start1.length != 0 && Bytes.compareTo(start1, end2) >= 0 || end1.length != 0 && start2.length != 0 && Bytes.compareTo(start2, end1) >= 0);
    }
}

