/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.tinkerpop.rexster;

import com.google.common.base.Joiner;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.rexster.config.GraphConfiguration;
import com.tinkerpop.rexster.config.GraphConfigurationContext;
import com.tinkerpop.rexster.config.GraphConfigurationException;
import java.io.File;
import java.util.Iterator;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitanGraphConfiguration
implements GraphConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TitanGraphConfiguration.class);

    public Graph configureGraphInstance(GraphConfigurationContext context) throws GraphConfigurationException {
        log.debug("Calling TitanFactory.open({})", (Object)context);
        TitanGraph g = TitanFactory.open((Configuration)this.convertConfiguration(context));
        log.debug("Returning new graph {}", (Object)g);
        return g;
    }

    public Configuration convertConfiguration(GraphConfigurationContext context) throws GraphConfigurationException {
        Configuration properties = context.getProperties();
        try {
            BaseConfiguration titanConfig = new BaseConfiguration();
            try {
                SubnodeConfiguration titanConfigProperties = ((HierarchicalConfiguration)properties).configurationAt("properties");
                Iterator titanConfigPropertiesKeys = titanConfigProperties.getKeys();
                while (titanConfigPropertiesKeys.hasNext()) {
                    String doubleDotKey = (String)titanConfigPropertiesKeys.next();
                    String singleDotKey = doubleDotKey.replace("..", ".");
                    String listVal = Joiner.on((char)AbstractConfiguration.getDefaultListDelimiter()).join((Object[])titanConfigProperties.getStringArray(doubleDotKey));
                    titanConfig.setProperty(singleDotKey, (Object)listVal);
                }
            }
            catch (IllegalArgumentException iae) {
                throw new GraphConfigurationException("Check graph configuration. Missing or empty configuration element: properties");
            }
            BaseConfiguration rewriteConfig = new BaseConfiguration();
            String location = properties.getString("graph-location", "");
            if (titanConfig.getString("storage.backend").equals("local") && location.trim().length() > 0) {
                File directory = new File(properties.getString("graph-location"));
                if (!directory.isDirectory() && !directory.mkdirs()) {
                    throw new IllegalArgumentException("Could not create directory: " + directory);
                }
                rewriteConfig.setProperty("storage.directory", (Object)directory.toString());
            }
            if (properties.containsKey("graph-read-only")) {
                rewriteConfig.setProperty("storage.read-only", (Object)properties.getBoolean("graph-read-only"));
            }
            CompositeConfiguration jointConfig = new CompositeConfiguration();
            jointConfig.addConfiguration((Configuration)rewriteConfig);
            jointConfig.addConfiguration((Configuration)titanConfig);
            return jointConfig;
        }
        catch (Exception e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            throw new GraphConfigurationException(cause);
        }
    }
}

