/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.hbase;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.PermanentStorageException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.TemporaryStorageException;
import com.thinkaurelius.titan.diskstorage.common.DistributedStoreManager;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigNamespace;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.hbase.HBaseCompatLoader;
import com.thinkaurelius.titan.diskstorage.hbase.HBaseKeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.hbase.HBaseTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRange;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StandardStoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import com.thinkaurelius.titan.diskstorage.util.time.Timestamps;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.configuration.PreInitializeConfigOptions;
import com.thinkaurelius.titan.util.system.IOUtils;
import com.thinkaurelius.titan.util.system.NetworkUtil;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public class HBaseStoreManager
extends DistributedStoreManager
implements KeyColumnValueStoreManager {
    private static final Logger logger = LoggerFactory.getLogger(HBaseStoreManager.class);
    public static final ConfigOption<String> HBASE_TABLE = new ConfigOption(GraphDatabaseConfiguration.STORAGE_NS, "tablename", "The name of the table to store Titan's data in", ConfigOption.Type.LOCAL, (Object)"titan");
    public static final ConfigOption<Boolean> SHORT_CF_NAMES = new ConfigOption(GraphDatabaseConfiguration.STORAGE_NS, "short-cf-names", "Whether to automatically shorten the names of frequently used column families to preserve space", ConfigOption.Type.FIXED, (Object)true);
    public static final String COMPRESSION_DEFAULT = "-DEFAULT-";
    public static final ConfigOption<String> COMPRESSION = new ConfigOption(GraphDatabaseConfiguration.STORAGE_NS, "compression-algorithm", "An HBase Compression.Algorithm enum string which will be applied to newly created column families", ConfigOption.Type.MASKABLE, (Object)"GZ");
    public static final int MIN_REGION_COUNT = 3;
    public static final ConfigOption<Boolean> SKIP_SCHEMA_CHECK = new ConfigOption(GraphDatabaseConfiguration.STORAGE_NS, "skip-schema-check", "Assume that Titan's HBase table and column families already exist. When this is true, Titan will not check for the existence of its table/CFs, nor will it attempt to create them under any circumstances.  This is useful when running Titan without HBase admin privileges.", ConfigOption.Type.MASKABLE, (Object)false);
    public static final ConfigOption<Integer> REGION_COUNT = new ConfigOption(GraphDatabaseConfiguration.STORAGE_NS, "region-count", "The number of initial regions set when creating Titan's HBase table", ConfigOption.Type.MASKABLE, Integer.class, (Predicate)new Predicate<Integer>(){

        public boolean apply(Integer input) {
            return null != input && 3 <= input;
        }
    });
    public static final ConfigOption<Integer> REGIONS_PER_SERVER = new ConfigOption(GraphDatabaseConfiguration.STORAGE_NS, "regions-per-server", "The number of regions per regionserver to set when creating Titan's HBase table", ConfigOption.Type.MASKABLE, Integer.class);
    public static final ConfigOption<String> HBASE_COMPAT_CLASS = new ConfigOption(GraphDatabaseConfiguration.STORAGE_NS, "hbase-compat-class", "The package and class name of the HBaseCompat implementation. HBaseCompat masks version-specific HBase API differences. When this option is unset, Titan calls HBase's VersionInfo.getVersion() and loads the matching compat class at runtime.  Setting this option forces Titan to instead reflectively load and instantiate the specified class.", ConfigOption.Type.MASKABLE, String.class);
    public static final int PORT_DEFAULT = 9160;
    public static final ConfigNamespace HBASE_CONFIGURATION_NAMESPACE = new ConfigNamespace(GraphDatabaseConfiguration.STORAGE_NS, "hbase-config", "General HBase configuration options", true);
    private static final BiMap<String, String> SHORT_CF_NAME_MAP = ImmutableBiMap.builder().put((Object)"graphindex", (Object)"v").put((Object)"titan_ids", (Object)"i").put((Object)"edgestore", (Object)"s").put((Object)"graphindex_lock_", (Object)"w").put((Object)"edgestore_lock_", (Object)"t").put((Object)"system_properties", (Object)"c").build();
    private static final StaticBuffer FOUR_ZERO_BYTES = BufferUtil.zeroBuffer((int)4);
    private final String tableName;
    private final String compression;
    private final int regionCount;
    private final int regionsPerServer;
    private final HConnection cnx;
    private final Configuration hconf;
    private final boolean shortCfNames;
    private final boolean skipSchemaCheck;
    private final String compatClass;
    private final ConcurrentMap<String, HBaseKeyColumnValueStore> openStores;

    public HBaseStoreManager(com.thinkaurelius.titan.diskstorage.configuration.Configuration config) throws StorageException {
        super(config, 9160);
        this.checkConfigDeprecation(config);
        this.tableName = (String)config.get(HBASE_TABLE, new String[0]);
        this.compression = (String)config.get(COMPRESSION, new String[0]);
        this.regionCount = config.has(REGION_COUNT, new String[0]) ? (Integer)config.get(REGION_COUNT, new String[0]) : -1;
        this.regionsPerServer = config.has(REGIONS_PER_SERVER, new String[0]) ? (Integer)config.get(REGIONS_PER_SERVER, new String[0]) : -1;
        this.skipSchemaCheck = (Boolean)config.get(SKIP_SCHEMA_CHECK, new String[0]);
        String string = this.compatClass = config.has(HBASE_COMPAT_CLASS, new String[0]) ? (String)config.get(HBASE_COMPAT_CLASS, new String[0]) : null;
        if (config.has(REGIONS_PER_SERVER, new String[0]) && config.has(REGION_COUNT, new String[0])) {
            logger.warn("Both {} and {} are set in Titan's configuration, but the former takes precedence and the latter will be ignored.", REGION_COUNT, REGIONS_PER_SERVER);
        }
        this.hconf = HBaseConfiguration.create();
        int keysLoaded = 0;
        Map configSub = config.getSubset(HBASE_CONFIGURATION_NAMESPACE, new String[0]);
        for (Map.Entry entry : configSub.entrySet()) {
            logger.debug("HBase configuration: setting {}={}", entry.getKey(), entry.getValue());
            if (entry.getValue() == null) continue;
            this.hconf.set((String)entry.getKey(), entry.getValue().toString());
            ++keysLoaded;
        }
        if (config.has(GraphDatabaseConfiguration.STORAGE_HOSTS, new String[0])) {
            String zkQuorumKey = "hbase.zookeeper.quorum";
            String csHostList = Joiner.on((String)",").join((Object[])config.get(GraphDatabaseConfiguration.STORAGE_HOSTS, new String[0]));
            this.hconf.set(zkQuorumKey, csHostList);
            logger.info("Copied host list from {} to {}: {}", new Object[]{GraphDatabaseConfiguration.STORAGE_HOSTS, zkQuorumKey, csHostList});
        }
        logger.debug("HBase configuration: set a total of {} configuration values", (Object)keysLoaded);
        this.shortCfNames = (Boolean)config.get(SHORT_CF_NAMES, new String[0]);
        try {
            this.cnx = HConnectionManager.createConnection((Configuration)this.hconf);
        }
        catch (ZooKeeperConnectionException e) {
            throw new PermanentStorageException((Throwable)e);
        }
        catch (IOException e) {
            throw new PermanentStorageException((Throwable)e);
        }
        this.openStores = new ConcurrentHashMap<String, HBaseKeyColumnValueStore>();
    }

    public DistributedStoreManager.Deployment getDeployment() {
        try {
            List<KeyRange> local = this.getLocalKeyPartition();
            return null != local && !local.isEmpty() ? DistributedStoreManager.Deployment.LOCAL : DistributedStoreManager.Deployment.REMOTE;
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "hbase[" + this.tableName + "@" + super.toString() + "]";
    }

    public void close() {
        this.openStores.clear();
        IOUtils.closeQuietly((Closeable)this.cnx);
    }

    public StoreFeatures getFeatures() {
        ModifiableConfiguration c = GraphDatabaseConfiguration.buildConfiguration();
        StandardStoreFeatures.Builder fb = new StandardStoreFeatures.Builder().orderedScan(true).unorderedScan(true).batchMutation(true).multiQuery(true).distributed(true).keyOrdered(true).keyConsistent((com.thinkaurelius.titan.diskstorage.configuration.Configuration)c);
        try {
            fb.localKeyPartition(this.getDeployment() == DistributedStoreManager.Deployment.LOCAL);
        }
        catch (Exception e) {
            logger.warn("Unexpected exception during getDeployment()", (Throwable)e);
        }
        return fb.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws StorageException {
        DistributedStoreManager.MaskedTimestamp commitTime = new DistributedStoreManager.MaskedTimestamp((DistributedStoreManager)this, txh);
        Map<StaticBuffer, Pair<Put, Delete>> commandsPerKey = this.convertToCommands(mutations, commitTime.getAdditionTime(this.times.getUnit()), commitTime.getDeletionTime(this.times.getUnit()));
        ArrayList<Object> batch = new ArrayList<Object>(commandsPerKey.size());
        for (Pair<Put, Delete> commands : commandsPerKey.values()) {
            if (commands.getFirst() != null) {
                batch.add(commands.getFirst());
            }
            if (commands.getSecond() == null) continue;
            batch.add(commands.getSecond());
        }
        try {
            HTableInterface table = null;
            try {
                table = this.cnx.getTable(this.tableName);
                table.batch(batch);
                table.flushCommits();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(table);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)table);
        }
        catch (IOException e) {
            throw new TemporaryStorageException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TemporaryStorageException((Throwable)e);
        }
        this.sleepAfterWrite(txh, commitTime);
    }

    public KeyColumnValueStore openDatabase(String longName) throws StorageException {
        String cfName;
        HBaseKeyColumnValueStore newStore;
        HBaseKeyColumnValueStore store = (HBaseKeyColumnValueStore)this.openStores.get(longName);
        if (store == null && (store = this.openStores.putIfAbsent(longName, newStore = new HBaseKeyColumnValueStore(this, this.cnx, this.tableName, cfName = this.shortCfNames ? this.shortenCfName(longName) : longName, longName))) == null) {
            if (!this.skipSchemaCheck) {
                this.ensureColumnFamilyExists(this.tableName, cfName);
            }
            store = newStore;
        }
        return store;
    }

    public StoreTransaction beginTransaction(BaseTransactionConfig config) throws StorageException {
        return new HBaseTransaction(config);
    }

    public String getName() {
        return this.tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStorage() throws StorageException {
        HBaseAdmin adm = this.getAdminInterface();
        try {
            if (!adm.tableExists(this.tableName)) {
                logger.debug("clearStorage() called before table {} was created, skipping.", (Object)this.tableName);
                return;
            }
        }
        catch (IOException e) {
            throw new TemporaryStorageException((Throwable)e);
        }
        HTable table = null;
        try {
            table = new HTable(this.hconf, this.tableName);
            Scan scan = new Scan();
            scan.setBatch(100);
            scan.setCacheBlocks(false);
            scan.setCaching(2000);
            scan.setTimeRange(0L, Long.MAX_VALUE);
            scan.setMaxVersions(1);
            ResultScanner scanner = null;
            long ts = -1L;
            try {
                scanner = table.getScanner(scan);
                for (Result res : scanner) {
                    Delete d = new Delete(res.getRow());
                    if (-1L == ts) {
                        ts = HBaseStoreManager.guessTimestamp(res);
                    }
                    d.setTimestamp(ts);
                    table.delete(d);
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)scanner);
            }
        }
        catch (IOException e) {
            try {
                throw new TemporaryStorageException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(table);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeyRange> getLocalKeyPartition() throws StorageException {
        LinkedList<KeyRange> result = new LinkedList<KeyRange>();
        HTable table = null;
        try {
            this.ensureTableExists(this.tableName);
            table = new HTable(this.hconf, this.tableName);
            Map<KeyRange, ServerName> normed = this.normalizeKeyBounds(table.getRegionLocations());
            for (Map.Entry<KeyRange, ServerName> e : normed.entrySet()) {
                if (NetworkUtil.isLocalConnection((String)e.getValue().getHostname())) {
                    result.add(e.getKey());
                    logger.debug("Found local key/row partition {} on host {}", (Object)e.getKey(), (Object)e.getValue());
                    continue;
                }
                logger.debug("Discarding remote {}", (Object)e.getValue());
            }
        }
        catch (MasterNotRunningException e) {
            logger.warn("Unexpected MasterNotRunningException", (Throwable)e);
        }
        catch (ZooKeeperConnectionException e) {
            logger.warn("Unexpected ZooKeeperConnectionException", (Throwable)e);
        }
        catch (IOException e) {
            logger.warn("Unexpected IOException", (Throwable)e);
        }
        finally {
            if (null != table) {
                try {
                    table.close();
                }
                catch (IOException e) {
                    logger.warn("Failed to close HTable {}", (Object)table, (Object)e);
                }
            }
        }
        return result;
    }

    private Map<KeyRange, ServerName> normalizeKeyBounds(NavigableMap<HRegionInfo, ServerName> raw) {
        Map.Entry nullStart = null;
        Map.Entry nullEnd = null;
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (Map.Entry e : raw.entrySet()) {
            HRegionInfo regionInfo = (HRegionInfo)e.getKey();
            byte[] startKey = regionInfo.getStartKey();
            byte[] endKey = regionInfo.getEndKey();
            if (0 == startKey.length) {
                startKey = null;
                logger.trace("Converted zero-length HBase startKey byte array to null");
            }
            if (0 == endKey.length) {
                endKey = null;
                logger.trace("Converted zero-length HBase endKey byte array to null");
            }
            if (null == startKey && null == endKey) {
                Preconditions.checkState((1 == raw.size() ? 1 : 0) != 0);
                logger.debug("HBase table {} has a single region {}", (Object)this.tableName, (Object)regionInfo);
                return b.put((Object)new KeyRange(FOUR_ZERO_BYTES, FOUR_ZERO_BYTES), e.getValue()).build();
            }
            if (null == startKey) {
                logger.debug("Found HRegionInfo with null startKey on server {}: {}", e.getValue(), (Object)regionInfo);
                Preconditions.checkState((null == nullStart ? 1 : 0) != 0);
                nullStart = e;
                StaticArrayBuffer endBuf = StaticArrayBuffer.of((byte[])this.zeroExtend(endKey));
                b.put((Object)new KeyRange(FOUR_ZERO_BYTES, (StaticBuffer)endBuf), e.getValue());
                continue;
            }
            if (null == endKey) {
                logger.debug("Found HRegionInfo with null endKey on server {}: {}", e.getValue(), (Object)regionInfo);
                Preconditions.checkState((null == nullEnd ? 1 : 0) != 0);
                nullEnd = e;
                b.put((Object)new KeyRange((StaticBuffer)StaticArrayBuffer.of((byte[])this.zeroExtend(startKey)), FOUR_ZERO_BYTES), e.getValue());
                continue;
            }
            Preconditions.checkState((null != startKey ? 1 : 0) != 0);
            Preconditions.checkState((null != endKey ? 1 : 0) != 0);
            StaticArrayBuffer startBuf = StaticArrayBuffer.of((byte[])this.zeroExtend(startKey));
            StaticArrayBuffer endBuf = StaticArrayBuffer.of((byte[])this.zeroExtend(endKey));
            KeyRange kr = new KeyRange((StaticBuffer)startBuf, (StaticBuffer)endBuf);
            b.put((Object)kr, e.getValue());
            logger.debug("Found HRegionInfo with non-null end and start keys on server {}: {}", e.getValue(), (Object)regionInfo);
        }
        Preconditions.checkState((!(null == nullStart ^ null == nullEnd) ? 1 : 0) != 0);
        ImmutableMap result = b.build();
        for (KeyRange kr : result.keySet()) {
            Preconditions.checkState((4 <= kr.getStart().length() ? 1 : 0) != 0);
            Preconditions.checkState((4 <= kr.getEnd().length() ? 1 : 0) != 0);
        }
        return result;
    }

    private final byte[] zeroExtend(byte[] dataToPad) {
        int i;
        assert (null != dataToPad);
        int targetLength = 4;
        if (4 <= dataToPad.length) {
            return dataToPad;
        }
        byte[] padded = new byte[4];
        for (i = 0; i < dataToPad.length; ++i) {
            padded[i] = dataToPad[i];
        }
        for (i = dataToPad.length; i < padded.length; ++i) {
            padded[i] = 0;
        }
        return padded;
    }

    private String shortenCfName(String longName) throws PermanentStorageException {
        String s;
        if (SHORT_CF_NAME_MAP.containsKey((Object)longName)) {
            s = (String)SHORT_CF_NAME_MAP.get((Object)longName);
            Preconditions.checkNotNull((Object)s);
            logger.debug("Substituted default CF name \"{}\" with short form \"{}\" to reduce HBase KeyValue size", (Object)longName, (Object)s);
        } else {
            if (SHORT_CF_NAME_MAP.containsValue((Object)longName)) {
                String fmt = "Must use CF long-form name \"%s\" instead of the short-form name \"%s\" when configured with %s=true";
                String msg = String.format(fmt, SHORT_CF_NAME_MAP.inverse().get((Object)longName), longName, SHORT_CF_NAMES.getName());
                throw new PermanentStorageException(msg);
            }
            s = longName;
            logger.debug("Kept default CF name \"{}\" because it has no associated short form", (Object)s);
        }
        return s;
    }

    private HTableDescriptor ensureTableExists(String tableName) throws StorageException {
        HTableDescriptor desc;
        HBaseAdmin adm = this.getAdminInterface();
        try {
            desc = adm.tableExists(tableName) ? adm.getTableDescriptor(tableName.getBytes()) : this.createTable(tableName, adm);
        }
        catch (IOException e) {
            throw new TemporaryStorageException((Throwable)e);
        }
        return desc;
    }

    private HTableDescriptor createTable(String name, HBaseAdmin adm) throws IOException {
        String src;
        HTableDescriptor desc = new HTableDescriptor(this.tableName);
        int count = this.regionCount;
        if (3 <= count) {
            src = "region count configuration";
        } else if (0 < this.regionsPerServer && 3 <= (count = this.regionsPerServer * this.getServerCount(adm))) {
            src = "ClusterStatus server count";
        } else {
            count = -1;
            src = "default";
        }
        if (3 < count) {
            adm.createTable(desc, this.getStartKey(count), this.getEndKey(count), count);
            logger.debug("Created table {} with region count {} from {}", new Object[]{this.tableName, count, src});
        } else {
            adm.createTable(desc);
            logger.debug("Created table {} with default start key, end key, and region count", (Object)this.tableName);
        }
        return desc;
    }

    private byte[] getStartKey(int regionCount) {
        ByteBuffer regionWidth = ByteBuffer.allocate(4);
        regionWidth.putInt((int)(0xFFFFFFFFL / (long)regionCount)).flip();
        return StaticArrayBuffer.of((ByteBuffer)regionWidth).getBytes(0, 4);
    }

    private byte[] getEndKey(int regionCount) {
        ByteBuffer regionWidth = ByteBuffer.allocate(4);
        regionWidth.putInt((int)(0xFFFFFFFFL / (long)regionCount * (long)(regionCount - 1))).flip();
        return StaticArrayBuffer.of((ByteBuffer)regionWidth).getBytes(0, 4);
    }

    private void ensureColumnFamilyExists(String tableName, String columnFamily) throws StorageException {
        HBaseAdmin adm = this.getAdminInterface();
        HTableDescriptor desc = this.ensureTableExists(tableName);
        Preconditions.checkNotNull((Object)desc);
        HColumnDescriptor cf = desc.getFamily(columnFamily.getBytes());
        if (cf == null) {
            try {
                if (!adm.isTableDisabled(tableName)) {
                    adm.disableTable(tableName);
                }
            }
            catch (TableNotEnabledException e) {
                logger.debug("Table {} already disabled", (Object)tableName);
            }
            catch (IOException e) {
                throw new TemporaryStorageException((Throwable)e);
            }
            try {
                HColumnDescriptor cdesc = new HColumnDescriptor(columnFamily);
                if (null != this.compression && !this.compression.equals(COMPRESSION_DEFAULT)) {
                    HBaseCompatLoader.getCompat(this.compatClass).setCompression(cdesc, this.compression);
                }
                adm.addColumn(tableName, cdesc);
                try {
                    logger.debug("Added HBase ColumnFamily {}, waiting for 1 sec. to propogate.", (Object)columnFamily);
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    throw new TemporaryStorageException((Throwable)ie);
                }
                adm.enableTable(tableName);
            }
            catch (TableNotFoundException ee) {
                logger.error("TableNotFoundException", (Throwable)ee);
                throw new PermanentStorageException((Throwable)ee);
            }
            catch (TableExistsException ee) {
                logger.debug("Swallowing exception {}", (Throwable)ee);
            }
            catch (IOException ee) {
                throw new TemporaryStorageException((Throwable)ee);
            }
        }
    }

    private static long guessTimestamp(Result res) {
        Timestamps prov;
        Long sampleTime = (Long)((NavigableMap)((NavigableMap)res.getMap().firstEntry().getValue()).firstEntry().getValue()).firstEntry().getKey();
        Preconditions.checkArgument((null != sampleTime ? 1 : 0) != 0);
        double exponent = Math.log10(sampleTime.longValue());
        if (12.0 <= exponent && exponent < 15.0) {
            prov = Timestamps.MILLI;
        } else if (15.0 <= exponent && exponent < 18.0) {
            prov = Timestamps.MICRO;
        } else if (18.0 <= exponent && exponent < 21.0) {
            prov = Timestamps.NANO;
        } else {
            throw new IllegalStateException("Timestamp " + sampleTime + " does not match expected UNIX Epoch timestamp in milli-, micro-, or nanosecond units.  clearStorage() does not support custom timestamps.");
        }
        logger.debug("Guessed timestamp provider " + prov);
        return prov.getTime().getNativeTimestamp();
    }

    private HBaseAdmin getAdminInterface() {
        try {
            return new HBaseAdmin(this.hconf);
        }
        catch (IOException e) {
            throw new TitanException((Throwable)e);
        }
    }

    private Map<StaticBuffer, Pair<Put, Delete>> convertToCommands(Map<String, Map<StaticBuffer, KCVMutation>> mutations, long putTimestamp, long delTimestamp) throws PermanentStorageException {
        HashMap<StaticBuffer, Pair<Put, Delete>> commandsPerKey = new HashMap<StaticBuffer, Pair<Put, Delete>>();
        for (Map.Entry<String, Map<StaticBuffer, KCVMutation>> entry : mutations.entrySet()) {
            String cfString = this.getCfNameForStoreName(entry.getKey());
            byte[] cfName = cfString.getBytes();
            for (Map.Entry<StaticBuffer, KCVMutation> m : entry.getValue().entrySet()) {
                byte[] key = (byte[])m.getKey().as(StaticBuffer.ARRAY_FACTORY);
                KCVMutation mutation = m.getValue();
                Pair commands = (Pair)commandsPerKey.get(m.getKey());
                if (commands == null) {
                    commands = new Pair();
                    commandsPerKey.put(m.getKey(), (Pair<Put, Delete>)commands);
                }
                if (mutation.hasDeletions()) {
                    if (commands.getSecond() == null) {
                        Delete d = new Delete(key);
                        d.setTimestamp(delTimestamp);
                        commands.setSecond((Object)d);
                    }
                    for (StaticBuffer b : mutation.getDeletions()) {
                        ((Delete)commands.getSecond()).deleteColumns(cfName, (byte[])b.as(StaticBuffer.ARRAY_FACTORY), delTimestamp);
                    }
                }
                if (!mutation.hasAdditions()) continue;
                if (commands.getFirst() == null) {
                    Put p = new Put(key, putTimestamp);
                    commands.setFirst((Object)p);
                }
                for (Entry e : mutation.getAdditions()) {
                    ((Put)commands.getFirst()).add(cfName, (byte[])e.getColumnAs(StaticBuffer.ARRAY_FACTORY), putTimestamp, (byte[])e.getValueAs(StaticBuffer.ARRAY_FACTORY));
                }
            }
        }
        return commandsPerKey;
    }

    private String getCfNameForStoreName(String storeName) throws PermanentStorageException {
        return this.shortCfNames ? this.shortenCfName(storeName) : storeName;
    }

    private int getServerCount(HBaseAdmin adm) {
        int serverCount = -1;
        try {
            serverCount = adm.getClusterStatus().getServers().size();
            logger.debug("Read {} servers from HBase ClusterStatus", (Object)serverCount);
        }
        catch (IOException e) {
            logger.debug("Unable to retrieve HBase cluster status", (Throwable)e);
        }
        return serverCount;
    }

    private void checkConfigDeprecation(com.thinkaurelius.titan.diskstorage.configuration.Configuration config) {
        if (config.has(GraphDatabaseConfiguration.STORAGE_PORT, new String[0])) {
            logger.warn("The configuration property {} is ignored for HBase. Set hbase.zookeeper.property.clientPort in hbase-site.xml or {}.hbase.zookeeper.property.clientPort in Titan's configuration file.", (Object)GraphDatabaseConfiguration.STORAGE_PORT, (Object)HBASE_CONFIGURATION_NAMESPACE);
        }
    }

    static {
        Preconditions.checkArgument((null != SHORT_CF_NAME_MAP ? 1 : 0) != 0);
        Set shorts = SHORT_CF_NAME_MAP.values();
        Preconditions.checkArgument((Sets.newHashSet((Iterable)shorts).size() == shorts.size() ? 1 : 0) != 0);
    }
}

