/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.hbase;

import com.thinkaurelius.titan.diskstorage.hbase.HBaseCompat;
import java.util.Arrays;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseCompatLoader {
    private static final Logger log = LoggerFactory.getLogger(HBaseCompatLoader.class);
    private static HBaseCompat cachedCompat;

    public static synchronized HBaseCompat getCompat(String classOverride) {
        if (null != cachedCompat) {
            log.debug("Returning cached HBase compatibility layer: {}", (Object)cachedCompat);
            return cachedCompat;
        }
        HBaseCompat compat = null;
        String className = null;
        String classNameSource = null;
        if (null != classOverride) {
            className = classOverride;
            classNameSource = "from explicit configuration";
        } else {
            String hbaseVersion = VersionInfo.getVersion();
            for (String supportedVersion : Arrays.asList("0.94", "0.96", "0.98")) {
                if (!hbaseVersion.startsWith(supportedVersion + ".")) continue;
                className = "com.thinkaurelius.titan.diskstorage.hbase.HBaseCompat" + supportedVersion.replaceAll("\\.", "_");
                classNameSource = "supporting runtime HBase version " + hbaseVersion;
                break;
            }
            if (null == className) {
                throw new RuntimeException("Unrecognized or unsupported HBase version " + hbaseVersion);
            }
        }
        String errTemplate = " when instantiating HBase compatibility class " + className;
        try {
            compat = (HBaseCompat)Class.forName(className).newInstance();
            log.info("Instantiated HBase compatibility layer {}: {}", (Object)classNameSource, (Object)compat.getClass().getCanonicalName());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getClass().getSimpleName() + errTemplate, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getClass().getSimpleName() + errTemplate, e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getClass().getSimpleName() + errTemplate, e);
        }
        cachedCompat = compat;
        return cachedCompat;
    }
}

