/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.guava14.collect;

import com.google.common.guava14.collect.BoundType;
import com.google.common.guava14.collect.ImmutableList;
import com.google.common.guava14.collect.ImmutableMultiset;
import com.google.common.guava14.collect.ImmutableSet;
import com.google.common.guava14.collect.ImmutableSortedMultiset;
import com.google.common.guava14.collect.ImmutableSortedSet;
import com.google.common.guava14.collect.Multiset;
import com.google.common.guava14.collect.UnmodifiableIterator;
import java.util.Set;
import javax.annotation.Nullable;

final class DescendingImmutableSortedMultiset<E>
extends ImmutableSortedMultiset<E> {
    private final transient ImmutableSortedMultiset<E> forward;

    DescendingImmutableSortedMultiset(ImmutableSortedMultiset<E> forward) {
        this.forward = forward;
    }

    @Override
    public int count(@Nullable Object element) {
        return this.forward.count(element);
    }

    @Override
    public Multiset.Entry<E> firstEntry() {
        return this.forward.lastEntry();
    }

    @Override
    public Multiset.Entry<E> lastEntry() {
        return this.forward.firstEntry();
    }

    @Override
    public int size() {
        return this.forward.size();
    }

    @Override
    public ImmutableSortedSet<E> elementSet() {
        return ((ImmutableSortedSet)this.forward.elementSet()).descendingSet();
    }

    @Override
    ImmutableSet<Multiset.Entry<E>> createEntrySet() {
        Set forwardEntrySet = this.forward.entrySet();
        return new ImmutableMultiset.EntrySet((ImmutableSet)forwardEntrySet){
            final /* synthetic */ ImmutableSet val$forwardEntrySet;
            {
                this.val$forwardEntrySet = immutableSet;
                super(DescendingImmutableSortedMultiset.this);
            }

            @Override
            public int size() {
                return this.val$forwardEntrySet.size();
            }

            @Override
            public UnmodifiableIterator<Multiset.Entry<E>> iterator() {
                return this.asList().iterator();
            }

            @Override
            ImmutableList<Multiset.Entry<E>> createAsList() {
                return this.val$forwardEntrySet.asList().reverse();
            }
        };
    }

    @Override
    public ImmutableSortedMultiset<E> descendingMultiset() {
        return this.forward;
    }

    @Override
    public ImmutableSortedMultiset<E> headMultiset(E upperBound, BoundType boundType) {
        return ((ImmutableSortedMultiset)this.forward.tailMultiset((Object)upperBound, boundType)).descendingMultiset();
    }

    @Override
    public ImmutableSortedMultiset<E> tailMultiset(E lowerBound, BoundType boundType) {
        return ((ImmutableSortedMultiset)this.forward.headMultiset((Object)lowerBound, boundType)).descendingMultiset();
    }

    @Override
    boolean isPartialView() {
        return this.forward.isPartialView();
    }
}

