/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools;

import java.util.Iterator;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.util.iterators.FilterIterator;

public class PatternIterator
extends FilterIterator<Statement> {
    private Resource subj;
    private URI pred;
    private Value obj;
    private Resource[] contexts;

    public PatternIterator(Iterator<? extends Statement> iter, Resource subj, URI pred, Value obj, Resource ... contexts) {
        super(iter);
        this.subj = subj;
        this.pred = pred;
        this.obj = obj;
        this.contexts = contexts;
    }

    protected boolean accept(Statement st) {
        if (this.subj != null && !this.subj.equals(st.getSubject())) {
            return false;
        }
        if (this.pred != null && !this.pred.equals(st.getPredicate())) {
            return false;
        }
        if (this.obj != null && !this.obj.equals(st.getObject())) {
            return false;
        }
        if (this.contexts.length == 0) {
            return true;
        }
        Resource stContext = st.getContext();
        for (Resource context : this.contexts) {
            if (context == null && stContext == null) {
                return true;
            }
            if (context == null || !context.equals(stContext)) continue;
            return true;
        }
        return false;
    }
}

