/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.reflect;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificDatumReader;

public class ReflectDatumReader<T>
extends SpecificDatumReader<T> {
    public ReflectDatumReader() {
    }

    public ReflectDatumReader(Class<T> c) {
        this(ReflectData.get().getSchema(c));
    }

    public ReflectDatumReader(Schema root) {
        super(root);
    }

    @Override
    protected void setField(Object record, String name, int position, Object o) {
        if (record instanceof IndexedRecord) {
            super.setField(record, name, position, o);
            return;
        }
        try {
            ReflectData.getField(record.getClass(), name).set(record, o);
        }
        catch (IllegalAccessException e) {
            throw new AvroRuntimeException(e);
        }
    }

    @Override
    protected Object getField(Object record, String name, int position) {
        if (record instanceof IndexedRecord) {
            return super.getField(record, name, position);
        }
        try {
            return ReflectData.getField(record.getClass(), name).get(record);
        }
        catch (IllegalAccessException e) {
            throw new AvroRuntimeException(e);
        }
    }

    @Override
    protected Object newArray(Object old, int size, Schema schema) {
        ReflectData data = ReflectData.get();
        Class collectionClass = ReflectData.getClassProp(schema, "java-class");
        if (collectionClass != null) {
            if (old instanceof Collection) {
                ((Collection)old).clear();
                return old;
            }
            if (collectionClass.isAssignableFrom(ArrayList.class)) {
                return new ArrayList();
            }
            return ReflectDatumReader.newInstance(collectionClass, schema);
        }
        Class elementClass = ReflectData.getClassProp(schema, "java-element-class");
        if (elementClass == null) {
            elementClass = data.getClass(schema.getElementType());
        }
        return Array.newInstance(elementClass, size);
    }

    @Override
    protected Object peekArray(Object array) {
        return null;
    }

    @Override
    protected void addToArray(Object array, long pos, Object e) {
        if (array instanceof Collection) {
            ((Collection)array).add(e);
        } else {
            Array.set(array, (int)pos, e);
        }
    }

    @Override
    protected Object readString(Object old, Schema s, Decoder in) throws IOException {
        String value = (String)this.readString(null, in);
        Class c = ReflectData.getClassProp(s, "java-class");
        if (c != null) {
            try {
                return c.getConstructor(String.class).newInstance(value);
            }
            catch (NoSuchMethodException e) {
                throw new AvroRuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new AvroRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new AvroRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new AvroRuntimeException(e);
            }
        }
        return value;
    }

    @Override
    protected Object readString(Object old, Decoder in) throws IOException {
        return super.readString(null, in).toString();
    }

    @Override
    protected Object createString(String value) {
        return value;
    }

    @Override
    protected Object readBytes(Object old, Decoder in) throws IOException {
        ByteBuffer bytes = in.readBytes(null);
        byte[] result = new byte[bytes.remaining()];
        bytes.get(result);
        return result;
    }

    @Override
    protected Object readInt(Object old, Schema expected, Decoder in) throws IOException {
        Number value = in.readInt();
        if (Short.class.getName().equals(expected.getProp("java-class"))) {
            value = value.shortValue();
        }
        return value;
    }
}

