/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.storage;

import com.google.common.collect.Maps;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.exceptions.NotFoundException;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.recipes.storage.ChunkedStorageProvider;
import com.netflix.astyanax.recipes.storage.ObjectMetadata;
import com.netflix.astyanax.retry.BoundedExponentialBackoff;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.serializers.StringSerializer;
import java.nio.ByteBuffer;
import java.util.Map;

public class CassandraChunkedStorageProvider
implements ChunkedStorageProvider {
    private static final RetryPolicy DEFAULT_RETRY_POLICY = new BoundedExponentialBackoff(1000, 10000, 5);
    private static final ConsistencyLevel DEFAULT_CONSISTENCY_LEVEL = ConsistencyLevel.CL_QUORUM;
    private static final int DEFAULT_CHUNKSIZE = 16384;
    private static final String DEFAULT_ROW_KEY_FORMAT = "%s$%d";
    private final ColumnFamily<String, String> cf;
    private final Keyspace keyspace;
    private final Map<Columns, String> names = Maps.newHashMap();
    private RetryPolicy retryPolicy = DEFAULT_RETRY_POLICY;
    private ConsistencyLevel consistencyLevel = DEFAULT_CONSISTENCY_LEVEL;
    private String rowKeyFormat = "%s$%d";

    public CassandraChunkedStorageProvider(Keyspace keyspace, String cfName) {
        this.keyspace = keyspace;
        this.cf = ColumnFamily.newColumnFamily((String)cfName, (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
    }

    public CassandraChunkedStorageProvider(Keyspace keyspace, ColumnFamily<String, String> cf) {
        this.keyspace = keyspace;
        this.cf = cf;
    }

    public CassandraChunkedStorageProvider withColumnName(Columns column, String name) {
        this.names.put(column, name);
        return this;
    }

    public CassandraChunkedStorageProvider withRowKeyFormat(String format) {
        this.rowKeyFormat = format;
        return this;
    }

    private String getColumnName(Columns column) {
        if (this.names.containsKey((Object)column)) {
            return this.names.get((Object)column);
        }
        return column.name();
    }

    @Override
    public int writeChunk(String objectName, int chunkId, ByteBuffer data, Integer ttl) throws Exception {
        MutationBatch m = this.keyspace.prepareMutationBatch().withRetryPolicy(this.retryPolicy);
        m.withRow(this.cf, (Object)this.getRowKey(objectName, chunkId)).putColumn((Object)this.getColumnName(Columns.DATA), data, ttl).putColumn((Object)this.getColumnName(Columns.CHUNKSIZE), data.limit(), ttl);
        if (chunkId == 0) {
            m.withRow(this.cf, (Object)objectName).putColumn((Object)this.getColumnName(Columns.CHUNKSIZE), data.limit(), ttl);
        }
        m.execute();
        return data.limit();
    }

    @Override
    public ByteBuffer readChunk(String objectName, int chunkId) throws Exception {
        return ((Column)this.keyspace.prepareQuery(this.cf).setConsistencyLevel(ConsistencyLevel.CL_ONE).withRetryPolicy(this.retryPolicy).getKey((Object)this.getRowKey(objectName, chunkId)).getColumn((Object)this.getColumnName(Columns.DATA)).execute().getResult()).getByteBufferValue();
    }

    private String getRowKey(String objectName, int chunkId) {
        return new String(this.rowKeyFormat).replace("%s", objectName).replace("%d", Integer.toString(chunkId));
    }

    public CassandraChunkedStorageProvider setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    @Override
    public void writeMetadata(String objectName, ObjectMetadata attr) throws Exception {
        MutationBatch m = this.keyspace.prepareMutationBatch().withRetryPolicy(this.retryPolicy);
        ColumnListMutation row = m.withRow(this.cf, (Object)objectName);
        if (attr.getChunkSize() != null) {
            row.putColumn((Object)this.getColumnName(Columns.CHUNKSIZE), attr.getChunkSize().intValue(), attr.getTtl());
        }
        if (attr.getChunkCount() != null) {
            row.putColumn((Object)this.getColumnName(Columns.CHUNKCOUNT), attr.getChunkCount().intValue(), attr.getTtl());
        }
        if (attr.getObjectSize() != null) {
            row.putColumn((Object)this.getColumnName(Columns.OBJECTSIZE), attr.getObjectSize().longValue(), attr.getTtl());
        }
        m.execute();
    }

    @Override
    public ObjectMetadata readMetadata(String objectName) throws Exception, NotFoundException {
        ColumnList columns = (ColumnList)this.keyspace.prepareQuery(this.cf).getKey((Object)objectName).execute().getResult();
        if (columns.isEmpty()) {
            throw new NotFoundException(objectName);
        }
        return new ObjectMetadata().setObjectSize(columns.getLongValue((Object)this.getColumnName(Columns.OBJECTSIZE), null)).setChunkSize(columns.getIntegerValue((Object)this.getColumnName(Columns.CHUNKSIZE), null)).setChunkCount(columns.getIntegerValue((Object)this.getColumnName(Columns.CHUNKCOUNT), null));
    }

    @Override
    public void deleteObject(String objectName, Integer chunkCount) throws Exception, NotFoundException {
        if (chunkCount == null) {
            ObjectMetadata attr = this.readMetadata(objectName);
            if (attr.getChunkCount() == null) {
                throw new NotFoundException("Object not found :" + objectName);
            }
            chunkCount = attr.getChunkCount();
        }
        MutationBatch m = this.keyspace.prepareMutationBatch().withRetryPolicy(this.retryPolicy);
        for (int i = 0; i < chunkCount; ++i) {
            m.withRow(this.cf, (Object)this.getRowKey(objectName, i)).delete();
        }
        m.withRow(this.cf, (Object)objectName).delete();
        m.execute();
    }

    @Override
    public int getDefaultChunkSize() {
        return 16384;
    }

    public static enum Columns {
        DATA,
        OBJECTSIZE,
        CHUNKSIZE,
        CHUNKCOUNT,
        EXPIRES;

    }
}

