/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.reader;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.connectionpool.TokenRange;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnSlice;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.partitioner.BigInteger127Partitioner;
import com.netflix.astyanax.partitioner.Partitioner;
import com.netflix.astyanax.query.CheckpointManager;
import com.netflix.astyanax.query.ColumnFamilyQuery;
import com.netflix.astyanax.query.RowSliceQuery;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.shallows.EmptyCheckpointManager;
import com.netflix.astyanax.util.Callables;
import java.io.Flushable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllRowsReader<K, C>
implements Callable<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(AllRowsReader.class);
    private static final Partitioner DEFAULT_PARTITIONER = BigInteger127Partitioner.get();
    private static final int DEFAULT_PAGE_SIZE = 100;
    private final Keyspace keyspace;
    private final ColumnFamily<K, C> columnFamily;
    private final int pageSize;
    private final Integer concurrencyLevel;
    private final ExecutorService executor;
    private final CheckpointManager checkpointManager;
    private final Function<Row<K, C>, Boolean> rowFunction;
    private final Function<Rows<K, C>, Boolean> rowsFunction;
    private final boolean repeatLastToken;
    private final ColumnSlice<C> columnSlice;
    private final String startToken;
    private final String endToken;
    private final Boolean includeEmptyRows;
    private final List<Future<Boolean>> futures = Lists.newArrayList();
    private final AtomicBoolean cancelling = new AtomicBoolean(false);
    private final Partitioner partitioner;
    private final ConsistencyLevel consistencyLevel;
    private final RetryPolicy retryPolicy;
    private AtomicReference<Exception> error = new AtomicReference();
    private String dc;
    private String rack;

    public AllRowsReader(Keyspace keyspace, ColumnFamily<K, C> columnFamily, Integer concurrencyLevel, ExecutorService executor, CheckpointManager checkpointManager, Function<Row<K, C>, Boolean> rowFunction, Function<Rows<K, C>, Boolean> rowsFunction, ColumnSlice<C> columnSlice, String startToken, String endToken, Boolean includeEmptyRows, int pageSize, boolean repeatLastToken, Partitioner partitioner, String dc, String rack, ConsistencyLevel consistencyLevel, RetryPolicy retryPolicy) {
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.concurrencyLevel = concurrencyLevel;
        this.executor = executor;
        this.checkpointManager = checkpointManager;
        this.rowFunction = rowFunction;
        this.rowsFunction = rowsFunction;
        this.columnSlice = columnSlice;
        this.startToken = startToken;
        this.endToken = endToken;
        this.pageSize = pageSize;
        this.repeatLastToken = repeatLastToken;
        this.partitioner = partitioner;
        this.dc = dc;
        this.rack = rack;
        this.consistencyLevel = consistencyLevel;
        this.retryPolicy = retryPolicy;
        this.includeEmptyRows = includeEmptyRows != null ? includeEmptyRows : (columnSlice != null && columnSlice.getColumns() == null && columnSlice.getLimit() == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false));
    }

    private ColumnFamilyQuery<K, C> prepareQuery() {
        ColumnFamilyQuery query = this.keyspace.prepareQuery(this.columnFamily);
        if (this.consistencyLevel != null) {
            query.setConsistencyLevel(this.consistencyLevel);
        }
        if (this.retryPolicy != null) {
            query.withRetryPolicy(this.retryPolicy);
        }
        return query;
    }

    private Callable<Boolean> makeTokenRangeTask(final String startToken, final String endToken) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    String currentToken;
                    try {
                        currentToken = AllRowsReader.this.checkpointManager.getCheckpoint(startToken);
                        if (currentToken == null) {
                            currentToken = startToken;
                        } else if (currentToken.equals(endToken)) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        AllRowsReader.this.error.compareAndSet(null, e);
                        LOG.error("Failed to get checkpoint for startToken " + startToken, (Throwable)e);
                        AllRowsReader.this.cancel();
                        throw new RuntimeException("Failed to get checkpoint for startToken " + startToken, e);
                    }
                    int localPageSize = AllRowsReader.this.pageSize;
                    int rowsToSkip = 0;
                    while (!AllRowsReader.this.cancelling.get()) {
                        Rows rows;
                        RowSliceQuery query = AllRowsReader.this.prepareQuery().getKeyRange(null, null, currentToken, endToken, localPageSize);
                        if (AllRowsReader.this.columnSlice != null) {
                            query.withColumnSlice(AllRowsReader.this.columnSlice);
                        }
                        if (!(rows = (Rows)query.execute().getResult()).isEmpty()) {
                            try {
                                if (AllRowsReader.this.rowsFunction != null) {
                                    if (!((Boolean)AllRowsReader.this.rowsFunction.apply((Object)rows)).booleanValue()) {
                                        AllRowsReader.this.cancel();
                                        return false;
                                    }
                                } else {
                                    for (Row row : rows) {
                                        if (AllRowsReader.this.cancelling.get()) break;
                                        if (rowsToSkip > 0) {
                                            --rowsToSkip;
                                            continue;
                                        }
                                        if (!AllRowsReader.this.includeEmptyRows.booleanValue() && (row.getColumns() == null || row.getColumns().isEmpty()) || ((Boolean)AllRowsReader.this.rowFunction.apply((Object)row)).booleanValue()) continue;
                                        AllRowsReader.this.cancel();
                                        return false;
                                    }
                                }
                            }
                            catch (Exception e) {
                                AllRowsReader.this.error.compareAndSet(null, e);
                                LOG.warn(e.getMessage(), (Throwable)e);
                                AllRowsReader.this.cancel();
                                throw new RuntimeException("Error processing row", e);
                            }
                            if (rows.size() == localPageSize) {
                                Row lastRow = rows.getRowByIndex(rows.size() - 1);
                                String lastToken = AllRowsReader.this.partitioner.getTokenForKey(lastRow.getRawKey());
                                AllRowsReader.this.checkpointManager.trackCheckpoint(startToken, currentToken);
                                if (AllRowsReader.this.repeatLastToken) {
                                    currentToken = AllRowsReader.this.partitioner.getTokenMinusOne(lastToken);
                                    rowsToSkip = 1;
                                    int i = rows.size() - 2;
                                    while (i >= 0 && lastToken.equals(AllRowsReader.this.partitioner.getTokenForKey(rows.getRowByIndex(i).getRawKey()))) {
                                        --i;
                                        ++rowsToSkip;
                                    }
                                    if (rowsToSkip != localPageSize) continue;
                                    ++localPageSize;
                                    continue;
                                }
                                currentToken = lastToken;
                                continue;
                            }
                        }
                        AllRowsReader.this.checkpointManager.trackCheckpoint(startToken, endToken);
                        return true;
                    }
                    AllRowsReader.this.cancel();
                    return false;
                }
                catch (Exception e) {
                    AllRowsReader.this.error.compareAndSet(null, e);
                    LOG.error("Error process token/key range", (Throwable)e);
                    AllRowsReader.this.cancel();
                    throw new RuntimeException("Error process token/key range", e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean call() throws Exception {
        this.error.set(null);
        ArrayList subtasks = Lists.newArrayList();
        if (this.concurrencyLevel != null || this.startToken != null || this.endToken != null) {
            List tokens = this.partitioner.splitTokenRange(this.startToken == null ? this.partitioner.getMinToken() : this.startToken, this.endToken == null ? this.partitioner.getMinToken() : this.endToken, this.concurrencyLevel == null ? 1 : this.concurrencyLevel);
            for (TokenRange range : tokens) {
                subtasks.add(this.makeTokenRangeTask(range.getStartToken(), range.getEndToken()));
            }
        } else {
            List ranges = this.keyspace.describeRing(this.dc, this.rack);
            for (TokenRange range : ranges) {
                if (range.getStartToken().equals(range.getEndToken())) {
                    subtasks.add(this.makeTokenRangeTask(range.getStartToken(), range.getEndToken()));
                    continue;
                }
                subtasks.add(this.makeTokenRangeTask(this.partitioner.getTokenMinusOne(range.getStartToken()), range.getEndToken()));
            }
        }
        try {
            if (this.executor != null) {
                this.futures.addAll(this.startTasks(this.executor, subtasks));
                return this.waitForTasksToFinish();
            }
            ExecutorService localExecutor = Executors.newFixedThreadPool(subtasks.size(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("AstyanaxAllRowsReader-%d").build());
            try {
                this.futures.addAll(this.startTasks(localExecutor, subtasks));
                Boolean bl = this.waitForTasksToFinish();
                return bl;
            }
            finally {
                localExecutor.shutdownNow();
            }
        }
        catch (Exception e) {
            this.error.compareAndSet(null, e);
            LOG.warn("AllRowsReader terminated. " + e.getMessage(), (Throwable)e);
            this.cancel();
            throw this.error.get();
        }
    }

    private boolean waitForTasksToFinish() throws Exception {
        for (Future<Boolean> future : this.futures) {
            try {
                if (future.get().booleanValue()) continue;
                this.cancel();
                return false;
            }
            catch (Exception e) {
                this.error.compareAndSet(null, e);
                this.cancel();
                throw e;
            }
        }
        if (this.rowFunction instanceof Flushable) {
            ((Flushable)this.rowFunction).flush();
        }
        return true;
    }

    private List<Future<Boolean>> startTasks(ExecutorService executor, List<Callable<Boolean>> callables) {
        ArrayList tasks = Lists.newArrayList();
        CyclicBarrier barrier = new CyclicBarrier(callables.size());
        for (Callable<Boolean> callable : callables) {
            tasks.add(executor.submit(Callables.decorateWithBarrier((CyclicBarrier)barrier, callable)));
        }
        return tasks;
    }

    public synchronized void cancel() {
        this.cancelling.compareAndSet(false, true);
    }

    static /* synthetic */ Partitioner access$000() {
        return DEFAULT_PARTITIONER;
    }

    public static class Builder<K, C> {
        private final Keyspace keyspace;
        private final ColumnFamily<K, C> columnFamily;
        private Partitioner partitioner = AllRowsReader.access$000();
        private int pageSize = 100;
        private Integer concurrencyLevel;
        private ExecutorService executor;
        private CheckpointManager checkpointManager = new EmptyCheckpointManager();
        private Function<Row<K, C>, Boolean> rowFunction;
        private Function<Rows<K, C>, Boolean> rowsFunction;
        private boolean repeatLastToken = true;
        private ColumnSlice<C> columnSlice;
        private String startToken;
        private String endToken;
        private Boolean includeEmptyRows;
        private String dc;
        private String rack;
        private ConsistencyLevel consistencyLevel = null;
        private RetryPolicy retryPolicy;

        public Builder(Keyspace ks, ColumnFamily<K, C> columnFamily) {
            this.keyspace = ks;
            this.columnFamily = columnFamily;
        }

        public Builder<K, C> withPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder<K, C> withCheckpointManager(CheckpointManager checkpointManager) {
            this.checkpointManager = checkpointManager;
            return this;
        }

        public Builder<K, C> withRepeatLastToken(boolean repeatLastToken) {
            this.repeatLastToken = repeatLastToken;
            return this;
        }

        public Builder<K, C> withColumnSlice(C ... columns) {
            this.columnSlice = new ColumnSlice((Collection)ImmutableList.copyOf((Object[])columns));
            return this;
        }

        public Builder<K, C> withColumnSlice(Collection<C> columns) {
            this.columnSlice = new ColumnSlice(columns);
            return this;
        }

        public Builder<K, C> withColumnSlice(ColumnSlice<C> columns) {
            this.columnSlice = columns;
            return this;
        }

        public Builder<K, C> withColumnRange(C startColumn, C endColumn, boolean reversed, int count) {
            this.columnSlice = new ColumnSlice(startColumn, endColumn).setReversed(reversed).setLimit(count);
            return this;
        }

        public Builder<K, C> withConcurrencyLevel(int concurrencyLevel) {
            Preconditions.checkArgument((concurrencyLevel >= 1 ? 1 : 0) != 0, (Object)"Concurrency level must be >= 1");
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public Builder<K, C> withTokenRange(BigInteger startToken, BigInteger endToken) {
            this.startToken = startToken.toString();
            this.endToken = endToken.toString();
            return this;
        }

        public Builder<K, C> withTokenRange(String startToken, String endToken) {
            this.startToken = startToken;
            this.endToken = endToken;
            return this;
        }

        public Builder<K, C> withPartitioner(Partitioner partitioner) {
            this.partitioner = partitioner;
            return this;
        }

        public Builder<K, C> withIncludeEmptyRows(Boolean flag) {
            this.includeEmptyRows = flag;
            return this;
        }

        public Builder<K, C> forEachRow(Function<Row<K, C>, Boolean> rowFunction) {
            this.rowFunction = rowFunction;
            return this;
        }

        public Builder<K, C> forEachPage(Function<Rows<K, C>, Boolean> rowsFunction) {
            this.rowsFunction = rowsFunction;
            return this;
        }

        public Builder<K, C> withConsistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public Builder<K, C> withDc(String dc) {
            this.dc = dc;
            return this;
        }

        public Builder<K, C> withRack(String rack) {
            this.rack = rack;
            return this;
        }

        public Builder<K, C> withRetryPolicy(RetryPolicy policy) {
            this.retryPolicy = policy;
            return this;
        }

        public AllRowsReader<K, C> build() {
            if (this.partitioner == null) {
                try {
                    this.partitioner = this.keyspace.getPartitioner();
                }
                catch (ConnectionException e) {
                    throw new RuntimeException("Unable to determine partitioner", e);
                }
            }
            return new AllRowsReader<K, C>(this.keyspace, this.columnFamily, this.concurrencyLevel, this.executor, this.checkpointManager, this.rowFunction, this.rowsFunction, this.columnSlice, this.startToken, this.endToken, this.includeEmptyRows, this.pageSize, this.repeatLastToken, this.partitioner, this.dc, this.rack, this.consistencyLevel, this.retryPolicy);
        }
    }
}

