/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes;

import com.google.common.collect.Lists;
import com.netflix.astyanax.serializers.StringSerializer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;

public class Shards {
    public static StringShardBuilder newStringShardBuilder() {
        return new StringShardBuilder();
    }

    public static class StringShardBuilder {
        private String prefix = "";
        private int shardCount = 0;

        public StringShardBuilder setPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public StringShardBuilder setShardCount(int count) {
            this.shardCount = count;
            return this;
        }

        public Collection<ByteBuffer> build() {
            ArrayList shards = Lists.newArrayListWithExpectedSize((int)this.shardCount);
            for (int i = 0; i < this.shardCount; ++i) {
                shards.add(StringSerializer.get().toByteBuffer(this.prefix + i));
            }
            return shards;
        }
    }

    public static interface Builder {
        public Collection<ByteBuffer> build();
    }
}

