/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.tinkerpop.gremlin;

import com.thinkaurelius.titan.hadoop.HadoopPipeline;
import com.thinkaurelius.titan.hadoop.hdfs.HDFSTools;
import com.thinkaurelius.titan.hadoop.hdfs.TextFileLineIterator;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.transform.ToStringPipe;
import com.tinkerpop.pipes.util.iterators.SingleIterator;
import groovy.lang.Closure;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.codehaus.groovy.tools.shell.IO;

public class ResultHookClosure
extends Closure {
    private final String resultPrompt;
    private final IO io;
    private static final int LINES = 15;

    public ResultHookClosure(Object owner, IO io, String resultPrompt) {
        super(owner);
        this.io = io;
        this.resultPrompt = resultPrompt;
    }

    public Object call(Object[] args) {
        Object itty;
        Object result = args[0];
        if (result instanceof HadoopPipeline) {
            try {
                HadoopPipeline pipeline = (HadoopPipeline)result;
                pipeline.submit();
                FileSystem hdfs = FileSystem.get((Configuration)pipeline.getGraph().getConf());
                Path output = HDFSTools.getOutputsFinalJob(hdfs, pipeline.getGraph().getOutputLocation().toString());
                itty = new TextFileLineIterator(hdfs, hdfs.globStatus(new Path(output.toString() + "/" + "sideeffect" + "*")), 15L);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        } else {
            itty = new ToStringPipe();
            ((Pipe)itty).setStarts((Iterator)new SingleIterator(result));
        }
        int counter = 0;
        while (itty.hasNext()) {
            ++counter;
            this.io.out.println(this.resultPrompt + itty.next());
        }
        if (counter == 15) {
            this.io.out.println(this.resultPrompt + "...");
        }
        return null;
    }
}

