/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.tinkerpop.gremlin;

import com.thinkaurelius.titan.hadoop.tinkerpop.gremlin.HadoopGremlin;
import com.thinkaurelius.titan.hadoop.tinkerpop.gremlin.Imports;
import com.thinkaurelius.titan.hadoop.tinkerpop.gremlin.ResultHookClosure;
import com.tinkerpop.gremlin.groovy.Gremlin;
import com.tinkerpop.gremlin.groovy.console.ErrorHookClosure;
import com.tinkerpop.gremlin.groovy.console.NullResultHookClosure;
import com.tinkerpop.gremlin.groovy.console.PromptClosure;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import jline.History;
import org.codehaus.groovy.tools.shell.Groovysh;
import org.codehaus.groovy.tools.shell.IO;
import org.codehaus.groovy.tools.shell.InteractiveShellRunner;
import org.codehaus.groovy.tools.shell.Shell;

public class Console {
    private static final String HISTORY_FILE = ".gremlin_titan_hadoop_history";
    private static final String STANDARD_INPUT_PROMPT = "gremlin> ";
    private static final String STANDARD_RESULT_PROMPT = "==>";

    public Console(IO io, String inputPrompt, String resultPrompt) {
        io.out.println();
        io.out.println("         \\,,,/");
        io.out.println("         (o o)");
        io.out.println("-----oOOo-(_)-oOOo-----");
        Groovysh groovy = new Groovysh();
        groovy.setResultHook((Closure)new NullResultHookClosure((Object)groovy));
        for (String imps : Imports.getImports()) {
            groovy.execute("import " + imps);
        }
        for (String evs : Imports.getEvaluates()) {
            groovy.execute(evs);
        }
        groovy.setResultHook((Closure)new ResultHookClosure(groovy, io, resultPrompt));
        groovy.setHistory(new History());
        InteractiveShellRunner runner = new InteractiveShellRunner((Shell)groovy, (Closure)new PromptClosure((Object)groovy, inputPrompt));
        runner.setErrorHandler((Closure)new ErrorHookClosure((Object)runner, io));
        try {
            runner.setHistory(new History(new File(System.getProperty("user.home") + "/" + HISTORY_FILE)));
        }
        catch (IOException e) {
            io.err.println("Unable to create history file: .gremlin_titan_hadoop_history");
        }
        Gremlin.load();
        HadoopGremlin.load();
        try {
            runner.run();
        }
        catch (Error e) {
            // empty catch block
        }
    }

    public Console() {
        this(new IO(System.in, (OutputStream)System.out, (OutputStream)System.err), STANDARD_INPUT_PROMPT, STANDARD_RESULT_PROMPT);
    }

    public static void main(String[] args) {
        new Console();
    }
}

