/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.util;

import com.thinkaurelius.titan.hadoop.HadoopElement;
import com.thinkaurelius.titan.hadoop.mapreduce.util.ElementPicker;
import com.tinkerpop.blueprints.Compare;

public class ElementChecker {
    private final String key;
    private final Compare compare;
    private final Object[] values;

    public ElementChecker(String key, Compare compare, Object ... values) {
        this.key = key;
        this.compare = compare;
        this.values = values;
    }

    public boolean isLegal(HadoopElement element) {
        Object elementValue = ElementPicker.getProperty(element, this.key);
        if (elementValue instanceof Number) {
            elementValue = Float.valueOf(((Number)elementValue).floatValue());
        }
        boolean legal = false;
        for (Object value : this.values) {
            legal = legal || this.compare.evaluate(elementValue, value);
        }
        return legal;
    }
}

