/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.transform;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopElement;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Holder;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;

public class VerticesVerticesMapReduce {
    public static final String DIRECTION = Tokens.makeNamespace(VerticesVerticesMapReduce.class) + ".direction";
    public static final String LABELS = Tokens.makeNamespace(VerticesVerticesMapReduce.class) + ".labels";

    public static Configuration createConfiguration(Direction direction, String ... labels) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.set(DIRECTION, direction.name());
        configuration.setStrings(LABELS, labels);
        return configuration;
    }

    public static class Reduce
    extends Reducer<LongWritable, Holder, NullWritable, HadoopVertex> {
        public void reduce(LongWritable key, Iterable<Holder> values, Reducer.Context context) throws IOException, InterruptedException {
            HadoopVertex vertex = new HadoopVertex(context.getConfiguration(), key.get());
            for (Holder holder : values) {
                char tag = holder.getTag();
                if (tag == 'v') {
                    vertex.addAll((HadoopVertex)holder.get());
                    continue;
                }
                if (tag == 'p') {
                    vertex.getPaths((HadoopElement)holder.get(), true);
                    continue;
                }
                vertex.getPaths((HadoopElement)holder.get(), false);
            }
            context.write((Object)NullWritable.get(), (Object)vertex);
        }
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, LongWritable, Holder> {
        private Direction direction;
        private String[] labels;
        private final Holder<HadoopVertex> holder = new Holder();
        private final LongWritable longWritable = new LongWritable();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.direction = Direction.valueOf((String)context.getConfiguration().get(DIRECTION));
            this.labels = context.getConfiguration().getStrings(LABELS, new String[0]);
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (value.hasPaths()) {
                HadoopVertex vertex;
                long edgesTraversed = 0L;
                if (this.direction.equals((Object)Direction.OUT) || this.direction.equals((Object)Direction.BOTH)) {
                    for (Edge edge : value.getEdges(Direction.OUT, this.labels)) {
                        vertex = new HadoopVertex(context.getConfiguration(), ((HadoopEdge)edge).getVertexId(Direction.IN));
                        vertex.getPaths(value, false);
                        this.longWritable.set(vertex.getIdAsLong());
                        context.write((Object)this.longWritable, this.holder.set('p', vertex));
                        ++edgesTraversed;
                    }
                }
                if (this.direction.equals((Object)Direction.IN) || this.direction.equals((Object)Direction.BOTH)) {
                    for (Edge edge : value.getEdges(Direction.IN, this.labels)) {
                        vertex = new HadoopVertex(context.getConfiguration(), ((HadoopEdge)edge).getVertexId(Direction.OUT));
                        vertex.getPaths(value, false);
                        this.longWritable.set(vertex.getIdAsLong());
                        context.write((Object)this.longWritable, this.holder.set('p', vertex));
                        ++edgesTraversed;
                    }
                }
                value.clearPaths();
                context.getCounter((Enum)Counters.EDGES_TRAVERSED).increment(edgesTraversed);
            }
            this.longWritable.set(value.getIdAsLong());
            context.write((Object)this.longWritable, this.holder.set('v', value));
        }
    }

    public static enum Counters {
        EDGES_TRAVERSED;

    }
}

