/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.transform;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;

public class VerticesMap {
    public static final String PROCESS_EDGES = Tokens.makeNamespace(VerticesMap.class) + ".processEdges";

    public static Configuration createConfiguration(boolean processEdges) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setBoolean(PROCESS_EDGES, processEdges);
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, NullWritable, HadoopVertex> {
        private boolean processEdges;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.processEdges = context.getConfiguration().getBoolean(PROCESS_EDGES, true);
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            value.startPath();
            long edgesProcessed = 0L;
            if (this.processEdges) {
                for (Edge edge : value.getEdges(Direction.BOTH)) {
                    ((HadoopEdge)edge).clearPaths();
                    ++edgesProcessed;
                }
            }
            context.getCounter((Enum)Counters.EDGES_PROCESSED).increment(edgesProcessed);
            context.getCounter((Enum)Counters.VERTICES_PROCESSED).increment(1L);
            context.write((Object)NullWritable.get(), (Object)value);
        }
    }

    public static enum Counters {
        VERTICES_PROCESSED,
        EDGES_PROCESSED;

    }
}

