/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.transform;

import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;

public class VertexMap {
    public static final String IDS = Tokens.makeNamespace(VertexMap.class) + ".ids";

    public static Configuration createConfiguration(long ... ids) {
        String[] idStrings = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            idStrings[i] = String.valueOf(ids[i]);
        }
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setStrings(IDS, idStrings);
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, NullWritable, HadoopVertex> {
        private Collection<Long> ids;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.ids = Map.getLongCollection(context.getConfiguration(), IDS, new HashSet<Long>());
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.ids.contains(value.getIdAsLong())) {
                value.startPath();
                context.getCounter((Enum)Counters.VERTICES_PROCESSED).increment(1L);
            } else {
                value.clearPaths();
            }
            context.write((Object)NullWritable.get(), (Object)value);
        }

        private static Collection<Long> getLongCollection(Configuration conf, String key, Collection<Long> collection) {
            for (String value : conf.getStrings(key)) {
                collection.add(Long.valueOf(value));
            }
            return collection;
        }
    }

    public static enum Counters {
        VERTICES_PROCESSED;

    }
}

