/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.transform;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.thinkaurelius.titan.hadoop.mapreduce.util.SafeMapperOutputs;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import groovy.lang.Closure;
import java.io.IOException;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;

public class TransformMap {
    public static final String CLASS = Tokens.makeNamespace(TransformMap.class) + ".class";
    public static final String CLOSURE = Tokens.makeNamespace(TransformMap.class) + ".closure";
    private static final ScriptEngine engine = new GremlinGroovyScriptEngine();

    public static Configuration createConfiguration(Class<? extends Element> klass, String closure) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setClass(CLASS, klass, Element.class);
        configuration.set(CLOSURE, closure);
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, NullWritable, Text> {
        private Closure closure;
        private boolean isVertex;
        private SafeMapperOutputs outputs;
        private final Text textWritable = new Text();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.isVertex = context.getConfiguration().getClass(CLASS, Element.class, Element.class).equals(Vertex.class);
            try {
                this.closure = (Closure)engine.eval(context.getConfiguration().get(CLOSURE));
            }
            catch (ScriptException e) {
                throw new IOException(e.getMessage(), e);
            }
            this.outputs = new SafeMapperOutputs(context);
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.isVertex) {
                if (value.hasPaths()) {
                    Object result = this.closure.call((Object)value);
                    this.textWritable.set(null == result ? "null" : result.toString());
                    int i = 0;
                    while ((long)i < value.pathCount()) {
                        this.outputs.write("sideeffect", (Writable)NullWritable.get(), (Writable)this.textWritable);
                        ++i;
                    }
                    context.getCounter((Enum)Counters.VERTICES_PROCESSED).increment(1L);
                }
            } else {
                long edgesProcessed = 0L;
                for (Edge e : value.getEdges(Direction.OUT)) {
                    HadoopEdge edge = (HadoopEdge)e;
                    if (!edge.hasPaths()) continue;
                    Object result = this.closure.call((Object)edge);
                    this.textWritable.set(null == result ? "null" : result.toString());
                    int i = 0;
                    while ((long)i < edge.pathCount()) {
                        this.outputs.write("sideeffect", (Writable)NullWritable.get(), (Writable)this.textWritable);
                        ++i;
                    }
                    ++edgesProcessed;
                }
                context.getCounter((Enum)Counters.EDGES_PROCESSED).increment(edgesProcessed);
            }
            this.outputs.write("graph", (Writable)NullWritable.get(), (Writable)value);
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            this.outputs.close();
        }
    }

    public static enum Counters {
        VERTICES_PROCESSED,
        EDGES_PROCESSED;

    }
}

