/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.transform;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.mapreduce.util.ElementPicker;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.thinkaurelius.titan.hadoop.mapreduce.util.SafeMapperOutputs;
import com.thinkaurelius.titan.hadoop.mapreduce.util.SafeReducerOutputs;
import com.thinkaurelius.titan.hadoop.mapreduce.util.WritableComparators;
import com.thinkaurelius.titan.hadoop.mapreduce.util.WritableHandler;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.pipes.transform.TransformPipe;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;

public class OrderMapReduce {
    public static final String CLASS = Tokens.makeNamespace(OrderMapReduce.class) + ".class";
    public static final String KEY = Tokens.makeNamespace(OrderMapReduce.class) + ".key";
    public static final String TYPE = Tokens.makeNamespace(OrderMapReduce.class) + ".type";
    public static final String ELEMENT_KEY = Tokens.makeNamespace(OrderMapReduce.class) + ".elementKey";

    public static Configuration createConfiguration(Class<? extends Element> klass, String key, Class<? extends WritableComparable> type, String elementKey) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setClass(CLASS, klass, Element.class);
        configuration.set(KEY, key);
        configuration.setClass(TYPE, type, WritableComparable.class);
        configuration.set(ELEMENT_KEY, elementKey);
        return configuration;
    }

    public static Class<? extends WritableComparator> createComparator(TransformPipe.Order order, Class<? extends WritableComparable> comparable) {
        Class comparatorClass = null;
        if (comparable.equals(LongWritable.class)) {
            comparatorClass = order.equals((Object)TransformPipe.Order.INCR) ? LongWritable.Comparator.class : LongWritable.DecreasingComparator.class;
        } else if (comparable.equals(IntWritable.class)) {
            comparatorClass = order.equals((Object)TransformPipe.Order.INCR) ? IntWritable.Comparator.class : WritableComparators.DecreasingIntComparator.class;
        } else if (comparable.equals(FloatWritable.class)) {
            comparatorClass = order.equals((Object)TransformPipe.Order.INCR) ? FloatWritable.Comparator.class : WritableComparators.DecreasingFloatComparator.class;
        } else if (comparable.equals(DoubleWritable.class)) {
            comparatorClass = order.equals((Object)TransformPipe.Order.INCR) ? DoubleWritable.Comparator.class : WritableComparators.DecreasingDoubleComparator.class;
        } else if (comparable.equals(Text.class)) {
            comparatorClass = order.equals((Object)TransformPipe.Order.INCR) ? Text.Comparator.class : WritableComparators.DecreasingTextComparator.class;
        }
        return comparatorClass;
    }

    private static Number multiplyPathCount(Number value, Long pathCount) {
        if (value instanceof Long) {
            return (Long)value * pathCount;
        }
        if (value instanceof Integer) {
            return (long)((Integer)value).intValue() * pathCount;
        }
        if (value instanceof Double) {
            return (Double)value * (double)pathCount.longValue();
        }
        if (value instanceof Float) {
            return Float.valueOf(((Float)value).floatValue() * (float)pathCount.longValue());
        }
        return value.doubleValue() * (double)pathCount.longValue();
    }

    public static class Reduce
    extends Reducer<WritableComparable, Text, Text, WritableComparable> {
        private SafeReducerOutputs outputs;

        public void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.outputs = new SafeReducerOutputs(context);
        }

        public void reduce(WritableComparable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            for (Text value : values) {
                this.outputs.write("sideeffect", (Writable)value, (Writable)key);
            }
        }

        public void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            this.outputs.close();
        }
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, WritableComparable, Text> {
        private String key;
        private boolean isVertex;
        private WritableHandler handler;
        private String elementKey;
        private SafeMapperOutputs outputs;
        private Text text = new Text();
        private WritableComparable writable;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.isVertex = context.getConfiguration().getClass(CLASS, Element.class, Element.class).equals(Vertex.class);
            this.key = context.getConfiguration().get(KEY);
            this.handler = new WritableHandler(context.getConfiguration().getClass(TYPE, Text.class, WritableComparable.class));
            this.elementKey = context.getConfiguration().get(ELEMENT_KEY);
            this.outputs = new SafeMapperOutputs(context);
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.isVertex) {
                if (value.hasPaths()) {
                    this.text.set(ElementPicker.getPropertyAsString(value, this.elementKey));
                    Object temp = ElementPicker.getProperty(value, this.key);
                    if (this.key.equals("_count")) {
                        this.writable = this.handler.set(temp);
                        context.write((Object)this.writable, (Object)this.text);
                    } else if (temp instanceof Number) {
                        this.writable = this.handler.set(OrderMapReduce.multiplyPathCount((Number)temp, value.pathCount()));
                        context.write((Object)this.writable, (Object)this.text);
                    } else {
                        this.writable = this.handler.set(temp);
                        int i = 0;
                        while ((long)i < value.pathCount()) {
                            context.write((Object)this.writable, (Object)this.text);
                            ++i;
                        }
                    }
                    context.getCounter((Enum)Counters.VERTICES_PROCESSED).increment(1L);
                }
            } else {
                long edgesProcessed = 0L;
                for (Edge e : value.getEdges(Direction.OUT)) {
                    HadoopEdge edge = (HadoopEdge)e;
                    if (!edge.hasPaths()) continue;
                    this.text.set(ElementPicker.getPropertyAsString(edge, this.elementKey));
                    Object temp = ElementPicker.getProperty(edge, this.key);
                    if (this.key.equals("_count")) {
                        this.writable = this.handler.set(temp);
                        context.write((Object)this.writable, (Object)this.text);
                    } else if (temp instanceof Number) {
                        this.writable = this.handler.set(OrderMapReduce.multiplyPathCount((Number)temp, edge.pathCount()));
                        context.write((Object)this.writable, (Object)this.text);
                    } else {
                        this.writable = this.handler.set(temp);
                        int i = 0;
                        while ((long)i < edge.pathCount()) {
                            context.write((Object)this.writable, (Object)this.text);
                            ++i;
                        }
                    }
                    ++edgesProcessed;
                }
                context.getCounter((Enum)Counters.OUT_EDGES_PROCESSED).increment(edgesProcessed);
            }
            this.outputs.write("graph", (Writable)NullWritable.get(), (Writable)value);
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            this.outputs.close();
        }
    }

    public static enum Counters {
        VERTICES_PROCESSED,
        OUT_EDGES_PROCESSED;

    }
}

